"use strict";(self.webpackChunknextcloud=self.webpackChunknextcloud||[]).push([[8589],{25238:(n,e,t)=>{t.d(e,{A:()=>a});var o=t(71354),i=t.n(o),s=t(76314),l=t.n(s)()(i());l.push([n.id,"\n.dialog-confirm-file-extension__checkbox[data-v-6b4a58b3] {\n\tmargin-top: 1rem;\n}\n","",{version:3,sources:["webpack://./apps/files/src/views/DialogConfirmFileExtension.vue"],names:[],mappings:";AA2FA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n - SPDX-FileCopyrightText: 2025 Nextcloud GmbH and Nextcloud contributors\n - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport type { IDialogButton } from '@nextcloud/dialogs'\n\nimport svgIconCancel from '@mdi/svg/svg/cancel.svg?raw'\nimport svgIconCheck from '@mdi/svg/svg/check.svg?raw'\nimport { t } from '@nextcloud/l10n'\nimport { computed, ref } from 'vue'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/components/NcCheckboxRadioSwitch'\nimport NcDialog from '@nextcloud/vue/components/NcDialog'\nimport { useUserConfigStore } from '../store/userconfig.ts'\n\nconst props = defineProps<{\n\toldExtension?: string\n\tnewExtension?: string\n}>()\n\nconst emit = defineEmits<{\n\t(e: 'close', v: boolean): void\n}>()\n\nconst userConfigStore = useUserConfigStore()\nconst dontShowAgain = computed({\n\tget: () => !userConfigStore.userConfig.show_dialog_file_extension,\n\tset: (value: boolean) => userConfigStore.update('show_dialog_file_extension', !value),\n})\n\nconst buttons = computed<IDialogButton[]>(() => [\n\t{\n\t\tlabel: props.oldExtension\n\t\t\t? t('files', 'Keep {old}', { old: props.oldExtension })\n\t\t\t: t('files', 'Keep without extension'),\n\t\ticon: svgIconCancel,\n\t\ttype: 'secondary',\n\t\tcallback: () => closeDialog(false),\n\t},\n\t{\n\t\tlabel: props.newExtension\n\t\t\t? t('files', 'Use {new}', { new: props.newExtension })\n\t\t\t: t('files', 'Remove extension'),\n\t\ticon: svgIconCheck,\n\t\ttype: 'primary',\n\t\tcallback: () => closeDialog(true),\n\t},\n])\n\n/** Open state of the dialog */\nconst open = ref(true)\n\n/**\n * Close the dialog and emit the response\n *\n * @param value User selected response\n */\nfunction closeDialog(value: boolean) {\n\temit('close', value)\n\topen.value = false\n}\n<\/script>\n\n<template>\n\t<NcDialog\n\t\t:buttons=\"buttons\"\n\t\t:open=\"open\"\n\t\tno-close\n\t\t:name=\"t('files', 'Change file extension')\"\n\t\tsize=\"small\">\n\t\t<p v-if=\"newExtension && oldExtension\">\n\t\t\t{{ t('files', 'Changing the file extension from \"{old}\" to \"{new}\" may render the file unreadable.', { old: oldExtension, new: newExtension }) }}\n\t\t</p>\n\t\t<p v-else-if=\"oldExtension\">\n\t\t\t{{ t('files', 'Removing the file extension \"{old}\" may render the file unreadable.', { old: oldExtension }) }}\n\t\t</p>\n\t\t<p v-else-if=\"newExtension\">\n\t\t\t{{ t('files', 'Adding the file extension \"{new}\" may render the file unreadable.', { new: newExtension }) }}\n\t\t</p>\n\n\t\t<NcCheckboxRadioSwitch\n\t\t\tv-model=\"dontShowAgain\"\n\t\t\tclass=\"dialog-confirm-file-extension__checkbox\"\n\t\t\ttype=\"checkbox\">\n\t\t\t{{ t('files', 'Do not show this dialog again.') }}\n\t\t</NcCheckboxRadioSwitch>\n\t</NcDialog>\n</template>\n\n<style scoped>\n.dialog-confirm-file-extension__checkbox {\n\tmargin-top: 1rem;\n}\n</style>\n"],sourceRoot:""}]);const a=l},88589:(n,e,t)=>{t.r(e),t.d(e,{default:()=>A});var o=t(85471),i=t(65659),s=t(53334),l=t(32073),a=t(94219),c=t(7421);const r=(0,o.pM)({__name:"DialogConfirmFileExtension",props:{oldExtension:null,newExtension:null},emits:["close"],setup(n,e){let{emit:t}=e;const r=n,d=(0,c.O)(),f=(0,o.EW)({get:()=>!d.userConfig.show_dialog_file_extension,set:n=>d.update("show_dialog_file_extension",!n)}),p=(0,o.EW)(()=>[{label:r.oldExtension?(0,s.t)("files","Keep {old}",{old:r.oldExtension}):(0,s.t)("files","Keep without extension"),icon:'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-cancel" viewBox="0 0 24 24"><path d="M12 2C17.5 2 22 6.5 22 12S17.5 22 12 22 2 17.5 2 12 6.5 2 12 2M12 4C10.1 4 8.4 4.6 7.1 5.7L18.3 16.9C19.3 15.5 20 13.8 20 12C20 7.6 16.4 4 12 4M16.9 18.3L5.7 7.1C4.6 8.4 4 10.1 4 12C4 16.4 7.6 20 12 20C13.9 20 15.6 19.4 16.9 18.3Z" /></svg>',type:"secondary",callback:()=>x(!1)},{label:r.newExtension?(0,s.t)("files","Use {new}",{new:r.newExtension}):(0,s.t)("files","Remove extension"),icon:i,type:"primary",callback:()=>x(!0)}]),g=(0,o.KR)(!0);function x(n){t("close",n),g.value=!1}return{__sfc:!0,props:r,emit:t,userConfigStore:d,dontShowAgain:f,buttons:p,open:g,closeDialog:x,t:s.t,NcCheckboxRadioSwitch:l.A,NcDialog:a.A}}});var d=t(85072),f=t.n(d),p=t(97825),g=t.n(p),x=t(77659),u=t.n(x),m=t(55056),h=t.n(m),w=t(10540),v=t.n(w),b=t(41113),C=t.n(b),_=t(25238),E={};E.styleTagTransform=C(),E.setAttributes=h(),E.insert=u().bind(null,"head"),E.domAPI=g(),E.insertStyleElement=v(),f()(_.A,E),_.A&&_.A.locals&&_.A.locals;const A=(0,t(14486).A)(r,function(){var n=this,e=n._self._c,t=n._self._setupProxy;return e(t.NcDialog,{attrs:{buttons:t.buttons,open:t.open,"no-close":"",name:t.t("files","Change file extension"),size:"small"}},[n.newExtension&&n.oldExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Changing the file extension from "{old}" to "{new}" may render the file unreadable.',{old:n.oldExtension,new:n.newExtension}))+"\n\t")]):n.oldExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Removing the file extension "{old}" may render the file unreadable.',{old:n.oldExtension}))+"\n\t")]):n.newExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Adding the file extension "{new}" may render the file unreadable.',{new:n.newExtension}))+"\n\t")]):n._e(),n._v(" "),e(t.NcCheckboxRadioSwitch,{staticClass:"dialog-confirm-file-extension__checkbox",attrs:{type:"checkbox"},model:{value:t.dontShowAgain,callback:function(n){t.dontShowAgain=n},expression:"dontShowAgain"}},[n._v("\n\t\t"+n._s(t.t("files","Do not show this dialog again."))+"\n\t")])],1)},[],!1,null,"6b4a58b3",null).exports}}]);
//# sourceMappingURL=8589-8589.js.map?v=4999ede01239247f8f54