/**
 * SPDX-FileCopyrightText: 2018-2024 Nextcloud GmbH and Nextcloud contributors
 * SPDX-FileCopyrightText: 2016 ownCloud, Inc.
 * SPDX-License-Identifier: AGPL-3.0-only
 */
window.addEventListener('DOMContentLoaded', function() {
	/**
	 *
	 * @param $tr
	 */
	function displayGranted($tr) {
		$tr.find('.configuration input.auth-param').attr('disabled', 'disabled').addClass('disabled-success')
	}

	OCA.Files_External.Settings.mountConfig.whenSelectAuthMechanism(function($tr, authMechanism, scheme, onCompletion) {
		if (authMechanism === 'oauth2::oauth2') {
			const config = $tr.find('.configuration')
			config.append($(document.createElement('input'))
				.addClass('button auth-param')
				.attr('type', 'button')
				.attr('value', t('files_external', 'Grant access'))
				.attr('name', 'oauth2_grant'))

			onCompletion.then(function() {
				const configured = $tr.find('[data-parameter="configured"]')
				if ($(configured).val() == 'true') {
					displayGranted($tr)
				} else {
					const client_id = $tr.find('.configuration [data-parameter="client_id"]').val()
					const client_secret = $tr.find('.configuration [data-parameter="client_secret"]')
						.val()
					if (client_id != '' && client_secret != '') {
						const params = {}
						window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m, key, value) {
							params[key] = value
						})
						if (params.code !== undefined) {
							const token = $tr.find('.configuration [data-parameter="token"]')
							const statusSpan = $tr.find('.status span')
							statusSpan.removeClass()
							statusSpan.addClass('waiting')
							$.post(
								OC.filePath('files_external', 'ajax', 'oauth2.php'),
								{
									step: 2,
									client_id,
									client_secret,
									redirect: location.protocol + '//' + location.host + location.pathname,
									code: params.code,
								},
								function(result) {
									if (result && result.status == 'success') {
										$(token).val(result.data.token)
										$(configured).val('true')
										OCA.Files_External.Settings.mountConfig.saveStorageConfig($tr, function(status) {
											if (status) {
												displayGranted($tr)
											}
										})
									} else {
										OC.dialogs.alert(
											result.data.message,
											t('files_external', 'Error configuring OAuth2'),
										)
									}
								},
							)
						}
					}
				}
			})
		}
	})

	$('#externalStorage').on('click', '[name="oauth2_grant"]', function(event) {
		event.preventDefault()
		const tr = $(this).parent().parent()
		const configured = $(this).parent().find('[data-parameter="configured"]')
		const client_id = $(this).parent().find('[data-parameter="client_id"]').val()
		const client_secret = $(this).parent().find('[data-parameter="client_secret"]').val()
		if (client_id != '' && client_secret != '') {
			const token = $(this).parent().find('[data-parameter="token"]')
			$.post(
				OC.filePath('files_external', 'ajax', 'oauth2.php'),
				{
					step: 1,
					client_id,
					client_secret,
					redirect: location.protocol + '//' + location.host + location.pathname,
				},
				function(result) {
					if (result && result.status == 'success') {
						$(configured).val('false')
						$(token).val('false')
						OCA.Files_External.Settings.mountConfig.saveStorageConfig(tr, function(status) {
							window.location = result.data.url
						})
					} else {
						OC.dialogs.alert(
							result.data.message,
							t('files_external', 'Error configuring OAuth2'),
						)
					}
				},
			)
		}
	})
})
