(()=>{var e,r,n,a={4708:(e,t,r)=>{"use strict";r.d(t,{A:()=>i});var n=r(71354),a=r.n(n),o=r(76314),s=r.n(o)()(a());s.push([e.id,"\n.settings-subsection[data-v-71d9be4a] {\n\tmargin-top: 20px;\n}\n.settings-subsection__name[data-v-71d9be4a] {\n\tdisplay: inline-flex;\n\talign-items: center;\n\tjustify-content: center;\n\tfont-size: 16px;\n\tfont-weight: bold;\n\tmax-width: 900px;\n\tmargin-top: 0;\n}\n","",{version:3,sources:["webpack://./apps/federatedfilesharing/src/components/AdminSettings.vue"],names:[],mappings:";AA+MA;CACA,gBAAA;AACA;AAEA;CACA,oBAAA;CACA,mBAAA;CACA,uBAAA;CACA,eAAA;CACA,iBAAA;CACA,gBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n - SPDX-FileCopyrightText: 2022 Nextcloud GmbH and Nextcloud contributors\n - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n<template>\n\t<NcSettingsSection\n\t\t:name=\"t('federatedfilesharing', 'Federated Cloud Sharing')\"\n\t\t:description=\"t('federatedfilesharing', 'Adjust how people can share between servers. This includes shares between people on this server as well if they are using federated sharing.')\"\n\t\t:doc-url=\"sharingFederatedDocUrl\">\n\t\t<NcCheckboxRadioSwitch\n\t\t\ttype=\"switch\"\n\t\t\t:checked.sync=\"outgoingServer2serverShareEnabled\"\n\t\t\t@update:checked=\"update('outgoing_server2server_share_enabled', outgoingServer2serverShareEnabled)\">\n\t\t\t{{ t('federatedfilesharing', 'Allow people on this server to send shares to other servers (this option also allows WebDAV access to public shares)') }}\n\t\t</NcCheckboxRadioSwitch>\n\n\t\t<NcCheckboxRadioSwitch\n\t\t\ttype=\"switch\"\n\t\t\t:checked.sync=\"incomingServer2serverShareEnabled\"\n\t\t\t@update:checked=\"update('incoming_server2server_share_enabled', incomingServer2serverShareEnabled)\">\n\t\t\t{{ t('federatedfilesharing', 'Allow people on this server to receive shares from other servers') }}\n\t\t</NcCheckboxRadioSwitch>\n\n\t\t<NcCheckboxRadioSwitch\n\t\t\tv-if=\"federatedGroupSharingSupported\"\n\t\t\ttype=\"switch\"\n\t\t\t:checked.sync=\"outgoingServer2serverGroupShareEnabled\"\n\t\t\t@update:checked=\"update('outgoing_server2server_group_share_enabled', outgoingServer2serverGroupShareEnabled)\">\n\t\t\t{{ t('federatedfilesharing', 'Allow people on this server to send shares to groups on other servers') }}\n\t\t</NcCheckboxRadioSwitch>\n\n\t\t<NcCheckboxRadioSwitch\n\t\t\tv-if=\"federatedGroupSharingSupported\"\n\t\t\ttype=\"switch\"\n\t\t\t:checked.sync=\"incomingServer2serverGroupShareEnabled\"\n\t\t\t@update:checked=\"update('incoming_server2server_group_share_enabled', incomingServer2serverGroupShareEnabled)\">\n\t\t\t{{ t('federatedfilesharing', 'Allow people on this server to receive group shares from other servers') }}\n\t\t</NcCheckboxRadioSwitch>\n\n\t\t<fieldset>\n\t\t\t<legend>{{ t('federatedfilesharing', 'The lookup server is only available for global scale.') }}</legend>\n\n\t\t\t<NcCheckboxRadioSwitch\n\t\t\t\ttype=\"switch\"\n\t\t\t\t:checked=\"lookupServerEnabled\"\n\t\t\t\tdisabled\n\t\t\t\t@update:checked=\"showLookupServerConfirmation\">\n\t\t\t\t{{ t('federatedfilesharing', 'Search global and public address book for people') }}\n\t\t\t</NcCheckboxRadioSwitch>\n\n\t\t\t<NcCheckboxRadioSwitch\n\t\t\t\ttype=\"switch\"\n\t\t\t\t:checked=\"lookupServerUploadEnabled\"\n\t\t\t\tdisabled\n\t\t\t\t@update:checked=\"showLookupServerUploadConfirmation\">\n\t\t\t\t{{ t('federatedfilesharing', 'Allow people to publish their data to a global and public address book') }}\n\t\t\t</NcCheckboxRadioSwitch>\n\t\t</fieldset>\n\n\t\t\x3c!-- Trusted server handling --\x3e\n\t\t<div class=\"settings-subsection\">\n\t\t\t<h3 class=\"settings-subsection__name\">\n\t\t\t\t{{ t('federatedfilesharing', 'Trusted federation') }}\n\t\t\t</h3>\n\t\t\t<NcCheckboxRadioSwitch\n\t\t\t\ttype=\"switch\"\n\t\t\t\t:checked.sync=\"federatedTrustedShareAutoAccept\"\n\t\t\t\t@update:checked=\"update('federatedTrustedShareAutoAccept', federatedTrustedShareAutoAccept)\">\n\t\t\t\t{{ t('federatedfilesharing', 'Automatically accept shares from trusted federated accounts and groups by default') }}\n\t\t\t</NcCheckboxRadioSwitch>\n\t\t</div>\n\t</NcSettingsSection>\n</template>\n\n<script>\nimport axios from '@nextcloud/axios'\nimport { DialogBuilder, showError } from '@nextcloud/dialogs'\nimport { loadState } from '@nextcloud/initial-state'\nimport { confirmPassword } from '@nextcloud/password-confirmation'\nimport { generateOcsUrl } from '@nextcloud/router'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/components/NcCheckboxRadioSwitch'\nimport NcSettingsSection from '@nextcloud/vue/components/NcSettingsSection'\nimport logger from '../services/logger.ts'\n\nexport default {\n\tname: 'AdminSettings',\n\n\tcomponents: {\n\t\tNcCheckboxRadioSwitch,\n\t\tNcSettingsSection,\n\t},\n\n\tdata() {\n\t\treturn {\n\t\t\toutgoingServer2serverShareEnabled: loadState('federatedfilesharing', 'outgoingServer2serverShareEnabled'),\n\t\t\tincomingServer2serverShareEnabled: loadState('federatedfilesharing', 'incomingServer2serverShareEnabled'),\n\t\t\toutgoingServer2serverGroupShareEnabled: loadState('federatedfilesharing', 'outgoingServer2serverGroupShareEnabled'),\n\t\t\tincomingServer2serverGroupShareEnabled: loadState('federatedfilesharing', 'incomingServer2serverGroupShareEnabled'),\n\t\t\tfederatedGroupSharingSupported: loadState('federatedfilesharing', 'federatedGroupSharingSupported'),\n\t\t\tlookupServerEnabled: loadState('federatedfilesharing', 'lookupServerEnabled'),\n\t\t\tlookupServerUploadEnabled: loadState('federatedfilesharing', 'lookupServerUploadEnabled'),\n\t\t\tfederatedTrustedShareAutoAccept: loadState('federatedfilesharing', 'federatedTrustedShareAutoAccept'),\n\t\t\tinternalOnly: loadState('federatedfilesharing', 'internalOnly'),\n\t\t\tsharingFederatedDocUrl: loadState('federatedfilesharing', 'sharingFederatedDocUrl'),\n\t\t}\n\t},\n\n\tmethods: {\n\t\tsetLookupServerUploadEnabled(state) {\n\t\t\tif (state === this.lookupServerUploadEnabled) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.lookupServerUploadEnabled = state\n\t\t\tthis.update('lookupServerUploadEnabled', state)\n\t\t},\n\n\t\tasync showLookupServerUploadConfirmation(state) {\n\t\t\t// No confirmation needed for disabling\n\t\t\tif (state === false) {\n\t\t\t\treturn this.setLookupServerUploadEnabled(false)\n\t\t\t}\n\n\t\t\tconst dialog = new DialogBuilder(t('federatedfilesharing', 'Confirm data upload to lookup server'))\n\t\t\tawait dialog\n\t\t\t\t.setSeverity('warning')\n\t\t\t\t.setText(t('federatedfilesharing', 'When enabled, all account properties (e.g. email address) with scope visibility set to \"published\", will be automatically synced and transmitted to an external system and made available in a public, global address book.'))\n\t\t\t\t.addButton({\n\t\t\t\t\tcallback: () => this.setLookupServerUploadEnabled(false),\n\t\t\t\t\tlabel: t('federatedfilesharing', 'Disable upload'),\n\t\t\t\t})\n\t\t\t\t.addButton({\n\t\t\t\t\tcallback: () => this.setLookupServerUploadEnabled(true),\n\t\t\t\t\tlabel: t('federatedfilesharing', 'Enable data upload'),\n\t\t\t\t\ttype: 'error',\n\t\t\t\t})\n\t\t\t\t.build()\n\t\t\t\t.show()\n\t\t},\n\n\t\tsetLookupServerEnabled(state) {\n\t\t\tif (state === this.lookupServerEnabled) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.lookupServerEnabled = state\n\t\t\tthis.update('lookupServerEnabled', state)\n\t\t},\n\n\t\tasync showLookupServerConfirmation(state) {\n\t\t\t// No confirmation needed for disabling\n\t\t\tif (state === false) {\n\t\t\t\treturn this.setLookupServerEnabled(false)\n\t\t\t}\n\n\t\t\tconst dialog = new DialogBuilder(t('federatedfilesharing', 'Confirm querying lookup server'))\n\t\t\tawait dialog\n\t\t\t\t.setSeverity('warning')\n\t\t\t\t.setText(t('federatedfilesharing', 'When enabled, the search input when creating shares will be sent to an external system that provides a public and global address book.')\n\t\t\t\t\t+ t('federatedfilesharing', 'This is used to retrieve the federated cloud ID to make federated sharing easier.')\n\t\t\t\t\t+ t('federatedfilesharing', 'Moreover, email addresses of users might be sent to that system in order to verify them.'))\n\t\t\t\t.addButton({\n\t\t\t\t\tcallback: () => this.setLookupServerEnabled(false),\n\t\t\t\t\tlabel: t('federatedfilesharing', 'Disable querying'),\n\t\t\t\t})\n\t\t\t\t.addButton({\n\t\t\t\t\tcallback: () => this.setLookupServerEnabled(true),\n\t\t\t\t\tlabel: t('federatedfilesharing', 'Enable querying'),\n\t\t\t\t\ttype: 'error',\n\t\t\t\t})\n\t\t\t\t.build()\n\t\t\t\t.show()\n\t\t},\n\n\t\tasync update(key, value) {\n\t\t\tawait confirmPassword()\n\n\t\t\tconst url = generateOcsUrl('/apps/provisioning_api/api/v1/config/apps/{appId}/{key}', {\n\t\t\t\tappId: 'files_sharing',\n\t\t\t\tkey,\n\t\t\t})\n\n\t\t\tconst stringValue = value ? 'yes' : 'no'\n\t\t\ttry {\n\t\t\t\tconst { data } = await axios.post(url, {\n\t\t\t\t\tvalue: stringValue,\n\t\t\t\t})\n\t\t\t\tthis.handleResponse({\n\t\t\t\t\tstatus: data.ocs?.meta?.status,\n\t\t\t\t})\n\t\t\t} catch (e) {\n\t\t\t\tthis.handleResponse({\n\t\t\t\t\terrorMessage: t('federatedfilesharing', 'Unable to update federated files sharing config'),\n\t\t\t\t\terror: e,\n\t\t\t\t})\n\t\t\t}\n\t\t},\n\n\t\tasync handleResponse({ status, errorMessage, error }) {\n\t\t\tif (status !== 'ok') {\n\t\t\t\tshowError(errorMessage)\n\t\t\t\tlogger.error(errorMessage, { error })\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n.settings-subsection {\n\tmargin-top: 20px;\n}\n\n.settings-subsection__name {\n\tdisplay: inline-flex;\n\talign-items: center;\n\tjustify-content: center;\n\tfont-size: 16px;\n\tfont-weight: bold;\n\tmax-width: 900px;\n\tmargin-top: 0;\n}\n</style>\n"],sourceRoot:""}]);const i=s},15340:()=>{},18346:(e,r,n)=>{"use strict";var a=n(21777),o=n(81222),s=n(53334),i=n(85471),d=n(19051),l=n(85168),c=n(12555),h=n(63814),u=n(32073),p=n(88837);const f=(0,n(35947).YK)().setApp("federatedfilesharing").build(),g={name:"AdminSettings",components:{NcCheckboxRadioSwitch:u.A,NcSettingsSection:p.A},data:()=>({outgoingServer2serverShareEnabled:(0,o.C)("federatedfilesharing","outgoingServer2serverShareEnabled"),incomingServer2serverShareEnabled:(0,o.C)("federatedfilesharing","incomingServer2serverShareEnabled"),outgoingServer2serverGroupShareEnabled:(0,o.C)("federatedfilesharing","outgoingServer2serverGroupShareEnabled"),incomingServer2serverGroupShareEnabled:(0,o.C)("federatedfilesharing","incomingServer2serverGroupShareEnabled"),federatedGroupSharingSupported:(0,o.C)("federatedfilesharing","federatedGroupSharingSupported"),lookupServerEnabled:(0,o.C)("federatedfilesharing","lookupServerEnabled"),lookupServerUploadEnabled:(0,o.C)("federatedfilesharing","lookupServerUploadEnabled"),federatedTrustedShareAutoAccept:(0,o.C)("federatedfilesharing","federatedTrustedShareAutoAccept"),internalOnly:(0,o.C)("federatedfilesharing","internalOnly"),sharingFederatedDocUrl:(0,o.C)("federatedfilesharing","sharingFederatedDocUrl")}),methods:{setLookupServerUploadEnabled(e){e!==this.lookupServerUploadEnabled&&(this.lookupServerUploadEnabled=e,this.update("lookupServerUploadEnabled",e))},async showLookupServerUploadConfirmation(e){if(!1===e)return this.setLookupServerUploadEnabled(!1);const r=new l.ik(t("federatedfilesharing","Confirm data upload to lookup server"));await r.setSeverity("warning").setText(t("federatedfilesharing",'When enabled, all account properties (e.g. email address) with scope visibility set to "published", will be automatically synced and transmitted to an external system and made available in a public, global address book.')).addButton({callback:()=>this.setLookupServerUploadEnabled(!1),label:t("federatedfilesharing","Disable upload")}).addButton({callback:()=>this.setLookupServerUploadEnabled(!0),label:t("federatedfilesharing","Enable data upload"),type:"error"}).build().show()},setLookupServerEnabled(e){e!==this.lookupServerEnabled&&(this.lookupServerEnabled=e,this.update("lookupServerEnabled",e))},async showLookupServerConfirmation(e){if(!1===e)return this.setLookupServerEnabled(!1);const r=new l.ik(t("federatedfilesharing","Confirm querying lookup server"));await r.setSeverity("warning").setText(t("federatedfilesharing","When enabled, the search input when creating shares will be sent to an external system that provides a public and global address book.")+t("federatedfilesharing","This is used to retrieve the federated cloud ID to make federated sharing easier.")+t("federatedfilesharing","Moreover, email addresses of users might be sent to that system in order to verify them.")).addButton({callback:()=>this.setLookupServerEnabled(!1),label:t("federatedfilesharing","Disable querying")}).addButton({callback:()=>this.setLookupServerEnabled(!0),label:t("federatedfilesharing","Enable querying"),type:"error"}).build().show()},async update(e,r){await(0,c.C5)();const n=(0,h.KT)("/apps/provisioning_api/api/v1/config/apps/{appId}/{key}",{appId:"files_sharing",key:e}),a=r?"yes":"no";try{const{data:e}=await d.Ay.post(n,{value:a});this.handleResponse({status:e.ocs?.meta?.status})}catch(e){this.handleResponse({errorMessage:t("federatedfilesharing","Unable to update federated files sharing config"),error:e})}},async handleResponse({status:e,errorMessage:t,error:r}){"ok"!==e&&((0,l.Qg)(t),f.error(t,{error:r}))}}};var v=n(85072),b=n.n(v),S=n(97825),m=n.n(S),k=n(77659),w=n.n(k),A=n(55056),y=n.n(A),E=n(10540),C=n.n(E),_=n(41113),x=n.n(_),N=n(4708),T={};T.styleTagTransform=x(),T.setAttributes=y(),T.insert=w().bind(null,"head"),T.domAPI=m(),T.insertStyleElement=C(),b()(N.A,T),N.A&&N.A.locals&&N.A.locals;const U=(0,n(14486).A)(g,function(){var e=this,t=e._self._c;return t("NcSettingsSection",{attrs:{name:e.t("federatedfilesharing","Federated Cloud Sharing"),description:e.t("federatedfilesharing","Adjust how people can share between servers. This includes shares between people on this server as well if they are using federated sharing."),"doc-url":e.sharingFederatedDocUrl}},[t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.outgoingServer2serverShareEnabled},on:{"update:checked":[function(t){e.outgoingServer2serverShareEnabled=t},function(t){return e.update("outgoing_server2server_share_enabled",e.outgoingServer2serverShareEnabled)}]}},[e._v("\n\t\t"+e._s(e.t("federatedfilesharing","Allow people on this server to send shares to other servers (this option also allows WebDAV access to public shares)"))+"\n\t")]),e._v(" "),t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.incomingServer2serverShareEnabled},on:{"update:checked":[function(t){e.incomingServer2serverShareEnabled=t},function(t){return e.update("incoming_server2server_share_enabled",e.incomingServer2serverShareEnabled)}]}},[e._v("\n\t\t"+e._s(e.t("federatedfilesharing","Allow people on this server to receive shares from other servers"))+"\n\t")]),e._v(" "),e.federatedGroupSharingSupported?t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.outgoingServer2serverGroupShareEnabled},on:{"update:checked":[function(t){e.outgoingServer2serverGroupShareEnabled=t},function(t){return e.update("outgoing_server2server_group_share_enabled",e.outgoingServer2serverGroupShareEnabled)}]}},[e._v("\n\t\t"+e._s(e.t("federatedfilesharing","Allow people on this server to send shares to groups on other servers"))+"\n\t")]):e._e(),e._v(" "),e.federatedGroupSharingSupported?t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.incomingServer2serverGroupShareEnabled},on:{"update:checked":[function(t){e.incomingServer2serverGroupShareEnabled=t},function(t){return e.update("incoming_server2server_group_share_enabled",e.incomingServer2serverGroupShareEnabled)}]}},[e._v("\n\t\t"+e._s(e.t("federatedfilesharing","Allow people on this server to receive group shares from other servers"))+"\n\t")]):e._e(),e._v(" "),t("fieldset",[t("legend",[e._v(e._s(e.t("federatedfilesharing","The lookup server is only available for global scale.")))]),e._v(" "),t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.lookupServerEnabled,disabled:""},on:{"update:checked":e.showLookupServerConfirmation}},[e._v("\n\t\t\t"+e._s(e.t("federatedfilesharing","Search global and public address book for people"))+"\n\t\t")]),e._v(" "),t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.lookupServerUploadEnabled,disabled:""},on:{"update:checked":e.showLookupServerUploadConfirmation}},[e._v("\n\t\t\t"+e._s(e.t("federatedfilesharing","Allow people to publish their data to a global and public address book"))+"\n\t\t")])],1),e._v(" "),t("div",{staticClass:"settings-subsection"},[t("h3",{staticClass:"settings-subsection__name"},[e._v("\n\t\t\t"+e._s(e.t("federatedfilesharing","Trusted federation"))+"\n\t\t")]),e._v(" "),t("NcCheckboxRadioSwitch",{attrs:{type:"switch",checked:e.federatedTrustedShareAutoAccept},on:{"update:checked":[function(t){e.federatedTrustedShareAutoAccept=t},function(t){return e.update("federatedTrustedShareAutoAccept",e.federatedTrustedShareAutoAccept)}]}},[e._v("\n\t\t\t"+e._s(e.t("federatedfilesharing","Automatically accept shares from trusted federated accounts and groups by default"))+"\n\t\t")])],1)],1)},[],!1,null,"71d9be4a",null).exports;n.nc=(0,a.aV)(),i.Ay.mixin({methods:{t:s.Tl}}),(0,o.C)("federatedfilesharing","internalOnly",!1)||(new(i.Ay.extend(U))).$mount("#vue-admin-federated")},47790:()=>{},51069:()=>{},63779:()=>{},64688:()=>{},66089:()=>{},73776:()=>{},77199:()=>{},77965:()=>{},78982:()=>{},79368:()=>{},79838:()=>{}},o={};function s(e){var t=o[e];if(void 0!==t)return t.exports;var r=o[e]={id:e,loaded:!1,exports:{}};return a[e].call(r.exports,r,r.exports,s),r.loaded=!0,r.exports}s.m=a,e=[],s.O=(t,r,n,a)=>{if(!r){var o=1/0;for(c=0;c<e.length;c++){for(var[r,n,a]=e[c],i=!0,d=0;d<r.length;d++)(!1&a||o>=a)&&Object.keys(s.O).every(e=>s.O[e](r[d]))?r.splice(d--,1):(i=!1,a<o&&(o=a));if(i){e.splice(c--,1);var l=n();void 0!==l&&(t=l)}}return t}a=a||0;for(var c=e.length;c>0&&e[c-1][2]>a;c--)e[c]=e[c-1];e[c]=[r,n,a]},s.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return s.d(t,{a:t}),t},s.d=(e,t)=>{for(var r in t)s.o(t,r)&&!s.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},s.f={},s.e=e=>Promise.all(Object.keys(s.f).reduce((t,r)=>(s.f[r](e,t),t),[])),s.u=e=>e+"-"+e+".js?v="+{594:"706f8e77fcd637f25ccf",2391:"a1c7f293d21dd6ef8096",3166:"6ee0264908909e0260a1",4325:"cc118df199f1941c08e4",5862:"4ca96c4f928b038599cf",7347:"ec35b00310c1ae3cecd4",8339:"3f9cf3b616cfbc0082d4",9507:"0a08b35d8e91ee8529d0"}[e],s.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),r={},n="nextcloud:",s.l=(e,t,a,o)=>{if(r[e])r[e].push(t);else{var i,d;if(void 0!==a)for(var l=document.getElementsByTagName("script"),c=0;c<l.length;c++){var h=l[c];if(h.getAttribute("src")==e||h.getAttribute("data-webpack")==n+a){i=h;break}}i||(d=!0,(i=document.createElement("script")).charset="utf-8",s.nc&&i.setAttribute("nonce",s.nc),i.setAttribute("data-webpack",n+a),i.src=e),r[e]=[t];var u=(t,n)=>{i.onerror=i.onload=null,clearTimeout(p);var a=r[e];if(delete r[e],i.parentNode&&i.parentNode.removeChild(i),a&&a.forEach(e=>e(n)),t)return t(n)},p=setTimeout(u.bind(null,void 0,{type:"timeout",target:i}),12e4);i.onerror=u.bind(null,i.onerror),i.onload=u.bind(null,i.onload),d&&document.head.appendChild(i)}},s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},s.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),s.j=5098,(()=>{var e;s.g.importScripts&&(e=s.g.location+"");var t=s.g.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var r=t.getElementsByTagName("script");if(r.length)for(var n=r.length-1;n>-1&&(!e||!/^http(s?):/.test(e));)e=r[n--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=e})(),(()=>{s.b="undefined"!=typeof document&&document.baseURI||self.location.href;var e={5098:0};s.f.j=(t,r)=>{var n=s.o(e,t)?e[t]:void 0;if(0!==n)if(n)r.push(n[2]);else{var a=new Promise((r,a)=>n=e[t]=[r,a]);r.push(n[2]=a);var o=s.p+s.u(t),i=new Error;s.l(o,r=>{if(s.o(e,t)&&(0!==(n=e[t])&&(e[t]=void 0),n)){var a=r&&("load"===r.type?"missing":r.type),o=r&&r.target&&r.target.src;i.message="Loading chunk "+t+" failed.\n("+a+": "+o+")",i.name="ChunkLoadError",i.type=a,i.request=o,n[1](i)}},"chunk-"+t,t)}},s.O.j=t=>0===e[t];var t=(t,r)=>{var n,a,[o,i,d]=r,l=0;if(o.some(t=>0!==e[t])){for(n in i)s.o(i,n)&&(s.m[n]=i[n]);if(d)var c=d(s)}for(t&&t(r);l<o.length;l++)a=o[l],s.o(e,a)&&e[a]&&e[a][0](),e[a]=0;return s.O(c)},r=self.webpackChunknextcloud=self.webpackChunknextcloud||[];r.forEach(t.bind(null,0)),r.push=t.bind(null,r.push.bind(r))})(),s.nc=void 0;var i=s.O(void 0,[4208],()=>s(18346));i=s.O(i)})();
//# sourceMappingURL=federatedfilesharing-vue-settings-admin.js.map?v=ec5eddb58f042723353a