"use strict";(self.webpackChunknextcloud_ui_legacy=self.webpackChunknextcloud_ui_legacy||[]).push([[4357],{3102:(n,e,t)=>{t.d(e,{A:()=>a});var o=t(71354),i=t.n(o),s=t(76314),l=t.n(s)()(i());l.push([n.id,"\n.dialog-confirm-file-extension__checkbox[data-v-d8709144] {\n\tmargin-top: 1rem;\n}\n","",{version:3,sources:["webpack://./apps/files/src/views/DialogConfirmFileExtension.vue"],names:[],mappings:";AA2FA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n - SPDX-FileCopyrightText: 2025 Nextcloud GmbH and Nextcloud contributors\n - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport type { IDialogButton } from '@nextcloud/dialogs'\n\nimport svgIconCancel from '@mdi/svg/svg/cancel.svg?raw'\nimport svgIconCheck from '@mdi/svg/svg/check.svg?raw'\nimport { t } from '@nextcloud/l10n'\nimport { computed, ref } from 'vue'\nimport NcCheckboxRadioSwitch from '@nextcloud/vue/components/NcCheckboxRadioSwitch'\nimport NcDialog from '@nextcloud/vue/components/NcDialog'\nimport { useUserConfigStore } from '../store/userconfig.ts'\n\nconst props = defineProps<{\n\toldExtension?: string\n\tnewExtension?: string\n}>()\n\nconst emit = defineEmits<{\n\t(e: 'close', v: boolean): void\n}>()\n\nconst userConfigStore = useUserConfigStore()\nconst dontShowAgain = computed({\n\tget: () => !userConfigStore.userConfig.show_dialog_file_extension,\n\tset: (value: boolean) => userConfigStore.update('show_dialog_file_extension', !value),\n})\n\nconst buttons = computed(() => [\n\t{\n\t\tlabel: props.oldExtension\n\t\t\t? t('files', 'Keep {old}', { old: props.oldExtension })\n\t\t\t: t('files', 'Keep without extension'),\n\t\ticon: svgIconCancel,\n\t\tvariant: 'secondary',\n\t\tcallback: () => closeDialog(false),\n\t},\n\t{\n\t\tlabel: props.newExtension\n\t\t\t? t('files', 'Use {new}', { new: props.newExtension })\n\t\t\t: t('files', 'Remove extension'),\n\t\ticon: svgIconCheck,\n\t\tvariant: 'primary',\n\t\tcallback: () => closeDialog(true),\n\t},\n] satisfies IDialogButton[])\n\n/** Open state of the dialog */\nconst open = ref(true)\n\n/**\n * Close the dialog and emit the response\n *\n * @param value User selected response\n */\nfunction closeDialog(value: boolean) {\n\temit('close', value)\n\topen.value = false\n}\n<\/script>\n\n<template>\n\t<NcDialog\n\t\t:buttons=\"buttons\"\n\t\t:open=\"open\"\n\t\tno-close\n\t\t:name=\"t('files', 'Change file extension')\"\n\t\tsize=\"small\">\n\t\t<p v-if=\"newExtension && oldExtension\">\n\t\t\t{{ t('files', 'Changing the file extension from \"{old}\" to \"{new}\" may render the file unreadable.', { old: oldExtension, new: newExtension }) }}\n\t\t</p>\n\t\t<p v-else-if=\"oldExtension\">\n\t\t\t{{ t('files', 'Removing the file extension \"{old}\" may render the file unreadable.', { old: oldExtension }) }}\n\t\t</p>\n\t\t<p v-else-if=\"newExtension\">\n\t\t\t{{ t('files', 'Adding the file extension \"{new}\" may render the file unreadable.', { new: newExtension }) }}\n\t\t</p>\n\n\t\t<NcCheckboxRadioSwitch\n\t\t\tv-model=\"dontShowAgain\"\n\t\t\tclass=\"dialog-confirm-file-extension__checkbox\"\n\t\t\ttype=\"checkbox\">\n\t\t\t{{ t('files', 'Do not show this dialog again.') }}\n\t\t</NcCheckboxRadioSwitch>\n\t</NcDialog>\n</template>\n\n<style scoped>\n.dialog-confirm-file-extension__checkbox {\n\tmargin-top: 1rem;\n}\n</style>\n"],sourceRoot:""}]);const a=l},54357:(n,e,t)=>{t.r(e),t.d(e,{default:()=>A});var o=t(85471),i=t(65659),s=t(53334),l=t(32073),a=t(94219),c=t(7421);const r=(0,o.pM)({__name:"DialogConfirmFileExtension",props:{oldExtension:null,newExtension:null},emits:["close"],setup(n,{emit:e}){const t=n,r=(0,c.O)(),d=(0,o.EW)({get:()=>!r.userConfig.show_dialog_file_extension,set:n=>r.update("show_dialog_file_extension",!n)}),f=(0,o.EW)(()=>[{label:t.oldExtension?(0,s.t)("files","Keep {old}",{old:t.oldExtension}):(0,s.t)("files","Keep without extension"),icon:'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-cancel" viewBox="0 0 24 24"><path d="M12 2C17.5 2 22 6.5 22 12S17.5 22 12 22 2 17.5 2 12 6.5 2 12 2M12 4C10.1 4 8.4 4.6 7.1 5.7L18.3 16.9C19.3 15.5 20 13.8 20 12C20 7.6 16.4 4 12 4M16.9 18.3L5.7 7.1C4.6 8.4 4 10.1 4 12C4 16.4 7.6 20 12 20C13.9 20 15.6 19.4 16.9 18.3Z" /></svg>',variant:"secondary",callback:()=>g(!1)},{label:t.newExtension?(0,s.t)("files","Use {new}",{new:t.newExtension}):(0,s.t)("files","Remove extension"),icon:i,variant:"primary",callback:()=>g(!0)}]),p=(0,o.KR)(!0);function g(n){e("close",n),p.value=!1}return{__sfc:!0,props:t,emit:e,userConfigStore:r,dontShowAgain:d,buttons:f,open:p,closeDialog:g,t:s.t,NcCheckboxRadioSwitch:l.A,NcDialog:a.A}}});var d=t(85072),f=t.n(d),p=t(97825),g=t.n(p),u=t(77659),x=t.n(u),m=t(55056),h=t.n(m),w=t(10540),v=t.n(w),b=t(41113),_=t.n(b),C=t(3102),E={};E.styleTagTransform=_(),E.setAttributes=h(),E.insert=x().bind(null,"head"),E.domAPI=g(),E.insertStyleElement=v(),f()(C.A,E),C.A&&C.A.locals&&C.A.locals;const A=(0,t(14486).A)(r,function(){var n=this,e=n._self._c,t=n._self._setupProxy;return e(t.NcDialog,{attrs:{buttons:t.buttons,open:t.open,"no-close":"",name:t.t("files","Change file extension"),size:"small"}},[n.newExtension&&n.oldExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Changing the file extension from "{old}" to "{new}" may render the file unreadable.',{old:n.oldExtension,new:n.newExtension}))+"\n\t")]):n.oldExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Removing the file extension "{old}" may render the file unreadable.',{old:n.oldExtension}))+"\n\t")]):n.newExtension?e("p",[n._v("\n\t\t"+n._s(t.t("files",'Adding the file extension "{new}" may render the file unreadable.',{new:n.newExtension}))+"\n\t")]):n._e(),n._v(" "),e(t.NcCheckboxRadioSwitch,{staticClass:"dialog-confirm-file-extension__checkbox",attrs:{type:"checkbox"},model:{value:t.dontShowAgain,callback:function(n){t.dontShowAgain=n},expression:"dontShowAgain"}},[n._v("\n\t\t"+n._s(t.t("files","Do not show this dialog again."))+"\n\t")])],1)},[],!1,null,"d8709144",null).exports}}]);
//# sourceMappingURL=4357-4357.js.map?v=023967749161a99b3b18