<?php

namespace Nelexa\Buffer;

class CastTest extends \PHPUnit_Framework_TestCase
{
    public function testCastToByte()
    {
        $actualCast = [
            -1997551530 => 86, -1960415292 => -60, -1799385197 => -109, -1721937620 => 44,
            -1530997534 => -30, -1526855311 => 113, -1298630511 => -111, -1259382890 => -106,
            -1074950937 => -25, -892932280 => 72, -737085923 => 29, -698175103 => -127,
            -616855785 => 23, -486032759 => -119, -447665782 => -118, -421148997 => -69,
            -412081654 => 10, -268644677 => -69, -244595046 => -102, -105212087 => 73,
            -132 => 124, -131 => 125, -130 => 126, -129 => 127, -128 => -128, -127 => -127,
            -126 => -126, -125 => -125, -124 => -124, -123 => -123, -120 => -120, -119 => -119,
            -116 => -116, -115 => -115, -113 => -113, -107 => -107, -106 => -106, -105 => -105,
            -104 => -104, -103 => -103, -100 => -100, -99 => -99, -91 => -91, -82 => -82,
            -80 => -80, -75 => -75, -74 => -74, -73 => -73, -72 => -72, -70 => -70, -67 => -67,
            -58 => -58, -57 => -57, -56 => -56, -55 => -55, -54 => -54, -53 => -53, -49 => -49,
            -47 => -47, -46 => -46, -44 => -44, -38 => -38, -27 => -27, -23 => -23, -14 => -14,
            -9 => -9, -8 => -8, -7 => -7, -6 => -6, -2 => -2, -1 => -1, 2 => 2, 3 => 3, 4 => 4,
            9 => 9, 11 => 11, 12 => 12, 14 => 14, 20 => 20, 23 => 23, 24 => 24, 27 => 27, 30 => 30,
            37 => 37, 41 => 41, 47 => 47, 48 => 48, 50 => 50, 51 => 51, 54 => 54, 55 => 55,
            57 => 57, 59 => 59, 68 => 68, 69 => 69, 70 => 70, 71 => 71, 74 => 74, 83 => 83,
            85 => 85, 88 => 88, 89 => 89, 93 => 93, 96 => 96, 103 => 103, 104 => 104, 107 => 107,
            111 => 111, 116 => 116, 120 => 120, 123 => 123, 124 => 124, 125 => 125, 126 => 126,
            127 => 127, 128 => -128, 129 => -127, 130 => -126, 131 => -125, 132 => -124,
            7207204 => 36, 233845854 => 94, 334702437 => 101, 340410750 => 126, 430326926 => -114,
            471183925 => 53, 499194653 => 29, 682760454 => 6, 691691143 => -121, 972475720 => 72,
            1130159086 => -18, 1238801648 => -16, 1273111800 => -8, 1326838210 => -62,
            1462828643 => 99, 1495706013 => -99, 1664325026 => -94, 1752068802 => -62,
            1798269036 => 108, 1883221567 => 63,
        ];

        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toByte($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToUnsignedByte()
    {
        $actualCast = [
            -2136595330 => 126, -2128000797 => 227, -2112934983 => 185, -2024602240 => 128,
            -1983244330 => 214, -1588151360 => 192, -1536373296 => 208, -1527028339 => 141,
            -1497595627 => 21, -1388221194 => 246, -1346350122 => 214, -1323025019 => 133,
            -951240289 => 159, -868324821 => 43, -817456424 => 216, -807634866 => 78,
            -557532140 => 20, -258867856 => 112, -247321292 => 52, -46127326 => 34,
            -132 => 124, -131 => 125, -130 => 126, -129 => 127, -128 => 128, -127 => 129,
            -126 => 130, -125 => 131, -124 => 132, -123 => 133, -122 => 134, -120 => 136,
            -118 => 138, -114 => 142, -109 => 147, -106 => 150, -105 => 151, -102 => 154,
            -99 => 157, -97 => 159, -87 => 169, -86 => 170, -82 => 174, -78 => 178,
            -75 => 181, -74 => 182, -69 => 187, -66 => 190, -58 => 198, -57 => 199, -54 => 202,
            -50 => 206, -34 => 222, -32 => 224, -25 => 231, -24 => 232, -23 => 233, -18 => 238,
            -17 => 239, -13 => 243, -11 => 245, -9 => 247, -7 => 249, -6 => 250, -5 => 251,
            -4 => 252, -3 => 253, 5 => 5, 11 => 11, 13 => 13, 14 => 14, 15 => 15, 17 => 17,
            18 => 18, 19 => 19, 23 => 23, 27 => 27, 29 => 29, 31 => 31, 38 => 38, 40 => 40,
            41 => 41, 46 => 46, 48 => 48, 54 => 54, 57 => 57, 59 => 59, 61 => 61, 62 => 62,
            65 => 65, 70 => 70, 71 => 71, 75 => 75, 76 => 76, 77 => 77, 79 => 79, 81 => 81,
            82 => 82, 95 => 95, 101 => 101, 104 => 104, 112 => 112, 114 => 114, 116 => 116,
            117 => 117, 119 => 119, 120 => 120, 122 => 122, 123 => 123, 124 => 124, 125 => 125,
            126 => 126, 127 => 127, 128 => 128, 129 => 129, 130 => 130, 131 => 131, 132 => 132,
            70749593 => 153, 373009742 => 78, 393363356 => 156, 403215862 => 246,
            526361226 => 138, 740206296 => 216, 744006616 => 216, 823793575 => 167,
            887569610 => 202, 889805411 => 99, 920302796 => 204, 973062939 => 27,
            1150941609 => 169, 1261437697 => 1, 1322397075 => 147, 1363958510 => 238,
            1656026962 => 82, 1721052657 => 241, 1945030068 => 180, 1986358021 => 5,
        ];

        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toUnsignedByte($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToShort()
    {
        $actualCast = [
            -1971175757 => 16051, -1968146222 => 30930, -1925425704 => 21976,
            -1868190929 => -21713, -1821565081 => 8039, -1685254381 => 3859,
            -1436069992 => 20376, -1185520696 => 25544, -1062425742 => -21646,
            -999882771 => -19, -816367898 => 14054, -725302878 => -15966,
            -490449662 => 21762, -378319475 => 19853, -304165789 => -13213,
            -275551518 => 27362, -262172158 => -28158, -254535372 => 6452, -
            72772953 => -27993, -41911111 => 31929, -32772 => 32764, -32771 => 32765,
            -32770 => 32766, -32769 => 32767, -32768 => -32768, -32767 => -32767,
            -32766 => -32766, -32765 => -32765, -32764 => -32764, -32763 => -32763,
            -31605 => -31605, -31279 => -31279, -31152 => -31152, -28716 => -28716,
            -27155 => -27155, -26048 => -26048, -24067 => -24067, -23840 => -23840,
            -23723 => -23723, -22833 => -22833, -22344 => -22344, -22189 => -22189,
            -22046 => -22046, -21882 => -21882, -21787 => -21787, -21011 => -21011,
            -20809 => -20809, -20377 => -20377, -20197 => -20197, -20025 => -20025,
            -18803 => -18803, -18692 => -18692, -18235 => -18235, -17069 => -17069,
            -16937 => -16937, -16602 => -16602, -15059 => -15059, -14614 => -14614,
            -14380 => -14380, -14106 => -14106, -12603 => -12603, -11774 => -11774,
            -9780 => -9780, -9540 => -9540, -8646 => -8646, -8387 => -8387, -8063 => -8063,
            -6846 => -6846, -4381 => -4381, -3648 => -3648, -2900 => -2900, -2408 => -2408,
            -4 => -4, 1168 => 1168, 1329 => 1329, 1834 => 1834, 2081 => 2081, 2710 => 2710,
            3355 => 3355, 4376 => 4376, 4868 => 4868, 5156 => 5156, 5287 => 5287,
            6027 => 6027, 6167 => 6167, 9684 => 9684, 10350 => 10350, 11797 => 11797,
            11982 => 11982, 12126 => 12126, 12444 => 12444, 12512 => 12512, 12674 => 12674,
            13176 => 13176, 13714 => 13714, 14760 => 14760, 16165 => 16165, 16665 => 16665,
            16862 => 16862, 17506 => 17506, 18983 => 18983, 19099 => 19099, 19513 => 19513,
            19574 => 19574, 19811 => 19811, 20268 => 20268, 20349 => 20349, 20794 => 20794,
            21199 => 21199, 21334 => 21334, 21891 => 21891, 21965 => 21965, 24248 => 24248,
            24844 => 24844, 25011 => 25011, 25254 => 25254, 26311 => 26311, 26521 => 26521,
            26586 => 26586, 26815 => 26815, 27370 => 27370, 27426 => 27426, 27756 => 27756,
            28437 => 28437, 29696 => 29696, 29953 => 29953, 30160 => 30160, 30393 => 30393,
            30968 => 30968, 31071 => 31071, 32763 => 32763, 32764 => 32764, 32765 => 32765,
            32766 => 32766, 32767 => 32767, 32768 => -32768, 32769 => -32767,
            32770 => -32766, 32771 => -32765, 32772 => -32764, 67183888 => 9488,
            351130529 => -11359, 416036100 => 13572, 419148444 => -19812,
            514228657 => -32335, 654021230 => -28050, 743113735 => 1031,
            805407091 => -30349, 875355480 => -8872, 878683109 => -23579,
            941712008 => 25224, 1505475186 => -17806, 1509506213 => 15525,
            1524854795 => 28683, 1581123294 => 1758, 1665603962 => 6522,
            1826409361 => -13423, 1979551636 => -28780, 2054791296 => -24448, 2143956813 => 12109,
        ];
        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toShort($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToUnsignedShort()
    {
        $actualCast = [
            -1545551207 => 49817, -1416288743 => 9753, -1374427376 => 59152,
            -1358269249 => 29887, -1356152893 => 49091, -1127384673 => 31135,
            -1122383938 => 51134, -1093018380 => 56564, -988578364 => 32196,
            -932564899 => 12381, -723356577 => 29791, -719126083 => 445,
            -513574700 => 30932, -480460457 => 49495, -379567831 => 16681,
            -277828067 => 44573, -238559590 => 56986, -236028290 => 32382,
            -220004359 => 65529, -46021472 => 50336, -32772 => 32764,
            -32771 => 32765, -32770 => 32766, -32769 => 32767, -32768 => 32768,
            -32767 => 32769, -32766 => 32770, -32765 => 32771, -32764 => 32772,
            -32763 => 32773, -32318 => 33218, -31670 => 33866, -31598 => 33938,
            -31443 => 34093, -31142 => 34394, -30229 => 35307, -29387 => 36149,
            -29306 => 36230, -29234 => 36302, -28815 => 36721, -28334 => 37202,
            -25406 => 40130, -25135 => 40401, -24032 => 41504, -22198 => 43338,
            -20584 => 44952, -19906 => 45630, -19621 => 45915, -19173 => 46363,
            -18876 => 46660, -18427 => 47109, -17124 => 48412, -16953 => 48583,
            -15452 => 50084, -15074 => 50462, -14621 => 50915, -12600 => 52936,
            -12373 => 53163, -12241 => 53295, -12204 => 53332, -11883 => 53653,
            -11614 => 53922, -11393 => 54143, -11251 => 54285, -11063 => 54473,
            -10834 => 54702, -8947 => 56589, -8940 => 56596, -8696 => 56840,
            -8592 => 56944, -8095 => 57441, -7949 => 57587, -7761 => 57775,
            -7415 => 58121, -7255 => 58281, -4564 => 60972, -1841 => 63695,
            -1537 => 63999, -1463 => 64073, -851 => 64685, -698 => 64838,
            1951 => 1951, 2211 => 2211, 2452 => 2452, 2540 => 2540, 3429 => 3429,
            3592 => 3592, 5413 => 5413, 5919 => 5919, 6061 => 6061, 6268 => 6268,
            6917 => 6917, 7153 => 7153, 7168 => 7168, 7833 => 7833, 10152 => 10152,
            10234 => 10234, 10604 => 10604, 10739 => 10739, 12036 => 12036,
            12427 => 12427, 14441 => 14441, 15158 => 15158, 15258 => 15258,
            15768 => 15768, 17450 => 17450, 17805 => 17805, 17865 => 17865,
            18795 => 18795, 18907 => 18907, 19026 => 19026, 20432 => 20432,
            20939 => 20939, 21141 => 21141, 21362 => 21362, 22254 => 22254,
            22941 => 22941, 24201 => 24201, 24874 => 24874, 25556 => 25556,
            25982 => 25982, 27238 => 27238, 28042 => 28042, 29510 => 29510,
            30145 => 30145, 30703 => 30703, 31015 => 31015, 31311 => 31311,
            32269 => 32269, 32397 => 32397, 32763 => 32763, 32764 => 32764,
            32765 => 32765, 32766 => 32766, 32767 => 32767, 32768 => 32768,
            32769 => 32769, 32770 => 32770, 32771 => 32771, 32772 => 32772,
            65185292 => 42508, 235338675 => 64435, 578753291 => 4875,
            725428702 => 10718, 831988380 => 8860, 880887738 => 18362,
            994444768 => 1504, 1024813905 => 27473, 1155681093 => 19269,
            1206707727 => 58895, 1237051794 => 59794, 1370943847 => 61799,
            1383859255 => 1079, 1392915340 => 13196, 1476657022 => 65406,
            1496526464 => 11904, 1545061262 => 50062, 1552719781 => 40869,
            1773429172 => 25012, 1899457496 => 27608,
        ];
        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toUnsignedShort($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToInteger()
    {
        $actualCast = [
            -8452929933163922722 => -427853090, -8227809746396717005 => -494477261,
            -8069447908768999435 => 2018383861, -7322911264700188104 => -774456776,
            -7157486745453003186 => 481623630, -6294471842345940868 => 2084931708,
            -5404213518254922788 => 437068764, -5121227846828842541 => 535667155,
            -5031464466134410432 => -737223872, -4427976296617921775 => -969067759,
            -4142492729853974452 => 1617586252, -3857943065800693273 => -817583641,
            -3850022288003099130 => -1707272698, -3545206896667219024 => 1558358960,
            -3304792279149730522 => -2133613274, -2947055917115005649 => -282745553,
            -2434852234131164058 => 537637990, -585511715851594644 => 1423316076,
            -536617668063548519 => -220222567, -461261921154970582 => 19188778,
            -2147483652 => 2147483644, -2147483651 => 2147483645, -2147483650 => 2147483646,
            -2147483649 => 2147483647, -2147483648 => -2147483648, -2147483647 => -2147483647,
            -2147483646 => -2147483646, -2147483645 => -2147483645, -2147483644 => -2147483644,
            -2147483643 => -2147483643, -2142666998 => -2142666998, -2111112991 => -2111112991,
            -1997217588 => -1997217588, -1966955733 => -1966955733, -1945305989 => -1945305989,
            -1935727095 => -1935727095, -1913777766 => -1913777766, -1907399486 => -1907399486,
            -1872185297 => -1872185297, -1817768170 => -1817768170, -1809184885 => -1809184885,
            -1715578898 => -1715578898, -1577437854 => -1577437854, -1539215067 => -1539215067,
            -1508269993 => -1508269993, -1474712926 => -1474712926, -1444810077 => -1444810077,
            -1416724699 => -1416724699, -1230624732 => -1230624732, -1066332637 => -1066332637,
            -1025824621 => -1025824621, -992283120 => -992283120, -987038548 => -987038548,
            -984948950 => -984948950, -954412209 => -954412209, -939075790 => -939075790,
            -925408230 => -925408230, -793882323 => -793882323, -699831952 => -699831952,
            -698682415 => -698682415, -613971751 => -613971751, -602932883 => -602932883,
            -594971095 => -594971095, -580811529 => -580811529, -496216881 => -496216881,
            -469326095 => -469326095, -425917711 => -425917711, -359291923 => -359291923,
            -323749607 => -323749607, -228392199 => -228392199, -177008858 => -177008858,
            -166848142 => -166848142, -124158916 => -124158916, -102650436 => -102650436,
            -37289172 => -37289172, -19690778 => -19690778, 4395181 => 4395181,
            54754652 => 54754652, 75855103 => 75855103, 161761412 => 161761412,
            189289804 => 189289804, 233340012 => 233340012, 244137255 => 244137255,
            259625493 => 259625493, 275176129 => 275176129, 313881666 => 313881666,
            318619740 => 318619740, 361580175 => 361580175, 409226251 => 409226251,
            595656064 => 595656064, 699826088 => 699826088, 743084268 => 743084268,
            797188569 => 797188569, 911067568 => 911067568, 919736047 => 919736047,
            933800054 => 933800054, 981043666 => 981043666, 1011235379 => 1011235379,
            1054793626 => 1054793626, 1066243960 => 1066243960, 1111879441 => 1111879441,
            1137927280 => 1137927280, 1161141390 => 1161141390, 1207494809 => 1207494809,
            1224323748 => 1224323748, 1449283101 => 1449283101, 1476184529 => 1476184529,
            1484497025 => 1484497025, 1502384742 => 1502384742, 1560706915 => 1560706915,
            1643117236 => 1643117236, 1698234817 => 1698234817, 1700075744 => 1700075744,
            1704418040 => 1704418040, 1797315426 => 1797315426, 1827706831 => 1827706831,
            1873827816 => 1873827816, 1880985817 => 1880985817, 1885321445 => 1885321445,
            1887945117 => 1887945117, 1910918422 => 1910918422, 1913396612 => 1913396612,
            1917787717 => 1917787717, 2017893546 => 2017893546, 2023721819 => 2023721819,
            2039230599 => 2039230599, 2047689033 => 2047689033, 2051371828 => 2051371828,
            2113394667 => 2113394667, 2115087454 => 2115087454, 2147483643 => 2147483643,
            2147483644 => 2147483644, 2147483645 => 2147483645, 2147483646 => 2147483646,
            2147483647 => 2147483647, 2147483648 => -2147483648, 2147483649 => -2147483647,
            2147483650 => -2147483646, 2147483651 => -2147483645, 2147483652 => -2147483644,
            327455818446817879 => -98022825, 672496567785689947 => -1148644517,
            792152072093005609 => -785287383, 1158754392966664154 => 649301978,
            1278651530880918028 => -240475636, 3110847094773196354 => 1652762178,
            3413345115981031970 => 1574775330, 3796731187096572787 => 311022451,
            4820534321106058373 => -1122304891, 4896272896071787352 => -440704168,
            5416563045183045367 => 866434807, 5691445208075489224 => 502288328,
            6819073379251083503 => 60119279, 7303323242445241002 => 1506638506,
            7332172857428419953 => -959961743, 7646687339917640626 => 742687666,
            8920184389710306811 => -139796997, 9024321225994333040 => -1771508880,
            9145625486009181568 => -2041174656, 9158246028883747635 => -1522572493,
        ];
        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toInt($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToUnsignedInteger()
    {
        $actualCast = [
            -8828932113531775224 => 988174088, -7828090724457198174 => 187878818,
            -7545005068607356200 => 2166555352, -6180013005281428198 => 820509978,
            -6072007252811478348 => 244550324, -5660547352329380296 => 2250317368,
            -5565331019887832226 => 2115998558, -4759428743990999011 => 480380957,
            -3954477486133169125 => 2529211419, -3655807572739950250 => 3282499926,
            -3372368140996826985 => 403318935, -2535801509511858890 => 1554347318,
            -2465348119161971711 => 2511100929, -2236391832617430983 => 641781817,
            -2216259712569952100 => 2655139996, -1985261835992256688 => 3884625744,
            -1403646043161133542 => 1325366810, -1117145770488479569 => 867451055,
            -418467636862935386 => 3267993254, -56945642043723349 => 2189046187,
            -2147483652 => 2147483644, -2147483651 => 2147483645, -2147483650 => 2147483646,
            -2147483649 => 2147483647, -2147483648 => 2147483648, -2147483647 => 2147483649,
            -2147483646 => 2147483650, -2147483645 => 2147483651, -2147483644 => 2147483652,
            -2147483643 => 2147483653, -2117373025 => 2177594271, -2096041860 => 2198925436,
            -2085299236 => 2209668060, -2075027272 => 2219940024, -1840198102 => 2454769194,
            -1838509590 => 2456457706, -1761991609 => 2532975687, -1673101190 => 2621866106,
            -1639045374 => 2655921922, -1635955752 => 2659011544, -1603451580 => 2691515716,
            -1412048907 => 2882918389, -1371267853 => 2923699443, -1356726173 => 2938241123,
            -1339647661 => 2955319635, -1238648054 => 3056319242, -1235985228 => 3058982068,
            -1053158605 => 3241808691, -1001847353 => 3293119943, -947719476 => 3347247820,
            -933098500 => 3361868796, -931941220 => 3363026076, -909764689 => 3385202607,
            -903828185 => 3391139111, -902419021 => 3392548275, -889390863 => 3405576433,
            -800969358 => 3493997938, -754863798 => 3540103498, -733394875 => 3561572421,
            -732264085 => 3562703211, -723061508 => 3571905788, -687630440 => 3607336856,
            -656521337 => 3638445959, -641159514 => 3653807782, -574042748 => 3720924548,
            -484453139 => 3810514157, -451429548 => 3843537748, -384042562 => 3910924734,
            -369278089 => 3925689207, -355941740 => 3939025556, -347870529 => 3947096767,
            -337105223 => 3957862073, -324979224 => 3969988072, -186559730 => 4108407566,
            -177881990 => 4117085306, -174455223 => 4120512073, -113198032 => 4181769264,
            -101455194 => 4193512102, 3247566 => 3247566, 7056894 => 7056894, 37982905 => 37982905,
            102721942 => 102721942, 120367902 => 120367902, 131098802 => 131098802,
            149697898 => 149697898, 175671830 => 175671830, 205852524 => 205852524,
            208289875 => 208289875, 217767742 => 217767742, 459120502 => 459120502,
            574068094 => 574068094, 641095145 => 641095145, 658830419 => 658830419,
            690676300 => 690676300, 701773339 => 701773339, 709110931 => 709110931,
            731722628 => 731722628, 798837210 => 798837210, 819990933 => 819990933,
            912629027 => 912629027, 990890039 => 990890039, 1018131378 => 1018131378,
            1073281498 => 1073281498, 1193197075 => 1193197075, 1209553263 => 1209553263,
            1244583127 => 1244583127, 1262106470 => 1262106470, 1298309267 => 1298309267,
            1302783738 => 1302783738, 1312432823 => 1312432823, 1460631232 => 1460631232,
            1464332686 => 1464332686, 1485792110 => 1485792110, 1497462232 => 1497462232,
            1512577020 => 1512577020, 1602608160 => 1602608160, 1716466972 => 1716466972,
            1739230715 => 1739230715, 1777289703 => 1777289703, 1866315228 => 1866315228,
            1877556734 => 1877556734, 1929669130 => 1929669130, 1959469805 => 1959469805,
            1961146571 => 1961146571, 1966221636 => 1966221636, 1968675697 => 1968675697,
            1970375630 => 1970375630, 1979086003 => 1979086003, 2069784384 => 2069784384,
            2123695038 => 2123695038, 2147483643 => 2147483643, 2147483644 => 2147483644,
            2147483645 => 2147483645, 2147483646 => 2147483646, 2147483647 => 2147483647,
            2147483648 => 2147483648, 2147483649 => 2147483649, 2147483650 => 2147483650,
            2147483651 => 2147483651, 2147483652 => 2147483652, 373886987528618573 => 4123574861,
            771009823256948802 => 1771122754, 1004387722978796655 => 82453615,
            1243209402936707322 => 2071447802, 1655422001120174598 => 170025478,
            1772149229859146775 => 3602680855, 2507262907742073252 => 2658840996,
            2813363649054078496 => 1037923872, 2876534798038013405 => 2233144797,
            3297680158231392904 => 3460067976, 3328118166197267052 => 3400952428,
            3572321990398647028 => 1560746740, 4149946872460889004 => 1908820908,
            5788410328610570922 => 2332623530, 5825079135471215377 => 1917657873,
            6555518071408694953 => 217585321, 6739408486548733086 => 3304946846,
            7079040899421182461 => 276175357, 8145391911457264336 => 2394952400,
            9147936191948800226 => 2903261410,
        ];
        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toUnsignedInt($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }

    public function testCastToLong()
    {
        $actualCast = [
            -9170085652559072218 => -9170085652559072218,
            -8762875851716154430 => -8762875851716154430,
            -8412777414798920406 => -8412777414798920406,
            -8411232067770162241 => -8411232067770162241,
            -7956962034042337916 => -7956962034042337916,
            -7741733997731069659 => -7741733997731069659,
            -7562413780647168309 => -7562413780647168309,
            -7279532752286714404 => -7279532752286714404,
            -6875053898264821215 => -6875053898264821215,
            -6546188122974899677 => -6546188122974899677,
            -6539319718043370422 => -6539319718043370422,
            -6269360680735574015 => -6269360680735574015,
            -6245212573735285524 => -6245212573735285524,
            -6008164560998165202 => -6008164560998165202,
            -5673130211365790481 => -5673130211365790481,
            -5550558879395416461 => -5550558879395416461,
            -5315545680575876829 => -5315545680575876829,
            -5270629292889039812 => -5270629292889039812,
            -5257244755715615860 => -5257244755715615860,
            -4697072760722166619 => -4697072760722166619,
            -4378266633934162190 => -4378266633934162190,
            -4351003675881447778 => -4351003675881447778,
            -4344868801464432933 => -4344868801464432933,
            -4043702893244004445 => -4043702893244004445,
            -3481799324128556516 => -3481799324128556516,
            -3401006296811244597 => -3401006296811244597,
            -3310806867794682093 => -3310806867794682093,
            -3057425529762577563 => -3057425529762577563,
            -3040853836146852724 => -3040853836146852724,
            -2817295230844194271 => -2817295230844194271,
            -2568471746216522125 => -2568471746216522125,
            -2519307567020828553 => -2519307567020828553,
            -1975798901698214275 => -1975798901698214275,
            -1859083390560038307 => -1859083390560038307,
            -1774553370580724902 => -1774553370580724902,
            -1634855409015608429 => -1634855409015608429,
            -1381951605941422786 => -1381951605941422786,
            -1196959685645247832 => -1196959685645247832,
            -1036253099502184090 => -1036253099502184090,
            -914626182071417150 => -914626182071417150,
            -912583761313393119 => -912583761313393119,
            -756029432352135202 => -756029432352135202,
            -669177640404047297 => -669177640404047297,
            -279752108241877035 => -279752108241877035,
            -14037444279643280 => -14037444279643280,
            89235183761627361 => 89235183761627361,
            98272798287346379 => 98272798287346379,
            341611274837543729 => 341611274837543729,
            617025623621229439 => 617025623621229439,
            688607913671564955 => 688607913671564955,
            700601410549691241 => 700601410549691241,
            700727038457061037 => 700727038457061037,
            816476720065344870 => 816476720065344870,
            955192676500220111 => 955192676500220111,
            1214033201966406170 => 1214033201966406170,
            1414590019617251171 => 1414590019617251171,
            1528545757917024358 => 1528545757917024358,
            1614326684909925062 => 1614326684909925062,
            1944672876122505798 => 1944672876122505798,
            2207144148508699333 => 2207144148508699333,
            2278302445836788036 => 2278302445836788036,
            2384226760042317776 => 2384226760042317776,
            2573344486686176471 => 2573344486686176471,
            2616173938058851058 => 2616173938058851058,
            2805044067171596076 => 2805044067171596076,
            2894299281119165483 => 2894299281119165483,
            3063062202059229841 => 3063062202059229841,
            3466271178310710564 => 3466271178310710564,
            3632373078879533041 => 3632373078879533041,
            3642290790028469551 => 3642290790028469551,
            3662343508920772932 => 3662343508920772932,
            3769065765930590922 => 3769065765930590922,
            4256964567272000930 => 4256964567272000930,
            4263913004739735112 => 4263913004739735112,
            4526517888199137475 => 4526517888199137475,
            4649412930539981605 => 4649412930539981605,
            4733367622092357447 => 4733367622092357447,
            4907150005690517596 => 4907150005690517596,
            5037687856571754869 => 5037687856571754869,
            5204427615109238084 => 5204427615109238084,
            5480343987422738941 => 5480343987422738941,
            5501650918319918819 => 5501650918319918819,
            5664389307290364572 => 5664389307290364572,
            5680136290368167730 => 5680136290368167730,
            5741424946854193175 => 5741424946854193175,
            6043965460032981040 => 6043965460032981040,
            6203696150695101213 => 6203696150695101213,
            6350747862140861316 => 6350747862140861316,
            6974846481983904529 => 6974846481983904529,
            7028264173177402809 => 7028264173177402809,
            7311629905623817713 => 7311629905623817713,
            7595125476648712557 => 7595125476648712557,
            7638473695518713044 => 7638473695518713044,
            7720855249472985748 => 7720855249472985748,
            7966241693142082724 => 7966241693142082724,
            8110180085178212388 => 8110180085178212388,
            8684182726111037256 => 8684182726111037256,
            8842898155976061943 => 8842898155976061943,
            8882296136384501261 => 8882296136384501261,
            8989594683105135694 => 8989594683105135694,
            9223372036854775803 => 9223372036854775803,
            9223372036854775804 => 9223372036854775804,
            9223372036854775805 => 9223372036854775805,
            9223372036854775806 => 9223372036854775806,
            9223372036854775807 => 9223372036854775807,
        ];
        $expectedCast = [];
        foreach ($actualCast as $i => $value) {
            $expectedCast[$i] = Cast::toLong($i);
        }
        $this->assertEquals($expectedCast, $actualCast);
    }
}
