/**
 * SPDX-FileCopyrightText: 2016 ownCloud Inc.
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

/* global Select2 */

/**
 * Select2 extension for toggling values in a multi-select dropdown
 *
 * @param Select2
 */
(function(Select2) {
	const Select2FindHighlightableChoices = Select2.class.multi.prototype.findHighlightableChoices
	Select2.class.multi.prototype.findHighlightableChoices = function() {
		if (this.opts.toggleSelect) {
			return this.results.find('.select2-result-selectable:not(.select2-disabled)')
		}
		return Select2FindHighlightableChoices.apply(this, arguments)
	}

	const Select2TriggerSelect = Select2.class.multi.prototype.triggerSelect
	Select2.class.multi.prototype.triggerSelect = function(data) {
		if (this.opts.toggleSelect && this.val().indexOf(this.id(data)) !== -1) {
			const self = this
			const val = this.id(data)

			const selectionEls = this.container.find('.select2-search-choice').filter(function() {
				return (self.id($(this).data('select2-data')) === val)
			})

			if (this.unselect(selectionEls)) {
				// also unselect in dropdown
				this.results.find('.select2-result.select2-selected').each(function() {
					const $this = $(this)
					if (self.id($this.data('select2-data')) === val) {
						$this.removeClass('select2-selected')
					}
				})
				this.clearSearch()
			}

			return false
		} else {
			return Select2TriggerSelect.apply(this, arguments)
		}
	}
})(Select2)
