(()=>{"use strict";var t,e,n,s={27514(t){t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},27518(t){t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},64505(t){t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},66763(t,e,n){n.d(e,{A:()=>l});var s=n(71354),o=n.n(s),a=n(76314),r=n.n(a)()(o());r.push([t.id,"\n._passwordSection__form_lsR4P {\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: calc(2 * var(--default-grid-baseline));\n\tmax-width: 300px !important;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/PasswordSection.vue"],names:[],mappings:";AA+EA;CACA,aAAA;CACA,sBAAA;CACA,2CAAA;CACA,2BAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2022 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<script setup lang=\"ts\">\nimport axios from '@nextcloud/axios'\nimport { showError, showSuccess } from '@nextcloud/dialogs'\nimport { t } from '@nextcloud/l10n'\nimport { generateUrl } from '@nextcloud/router'\nimport { NcFormBox } from '@nextcloud/vue'\nimport { ref } from 'vue'\nimport NcButton from '@nextcloud/vue/components/NcButton'\nimport NcPasswordField from '@nextcloud/vue/components/NcPasswordField'\nimport NcSettingsSection from '@nextcloud/vue/components/NcSettingsSection'\n\nconst passwordform = ref<HTMLFormElement>()\n\nconst oldPass = ref('')\nconst newPass = ref('')\n\n/**\n * Change the user's password\n */\nasync function changePassword() {\n\tconst { data } = await axios.post(generateUrl('/settings/personal/changepassword'), {\n\t\toldpassword: oldPass.value,\n\t\tnewpassword: newPass.value,\n\t})\n\tif (data.status === 'error') {\n\t\tshowError(data.data.message)\n\t} else {\n\t\tshowSuccess(data.data.message)\n\t\toldPass.value = ''\n\t\tnewPass.value = ''\n\t\tpasswordform.value?.reset()\n\t}\n}\n<\/script>\n\n<template>\n\t<NcSettingsSection :name=\"t('settings', 'Password')\">\n\t\t<form\n\t\t\tref=\"passwordform\"\n\t\t\t:class=\"$style.passwordSection__form\"\n\t\t\t@submit.prevent=\"changePassword\">\n\t\t\t<NcFormBox>\n\t\t\t\t<NcPasswordField\n\t\t\t\t\tv-model=\"oldPass\"\n\t\t\t\t\t:label=\"t('settings', 'Current password')\"\n\t\t\t\t\tname=\"oldpassword\"\n\t\t\t\t\tautocomplete=\"current-password\"\n\t\t\t\t\tautocapitalize=\"none\"\n\t\t\t\t\trequired\n\t\t\t\t\tspellcheck=\"false\" />\n\n\t\t\t\t<NcPasswordField\n\t\t\t\t\tv-model=\"newPass\"\n\t\t\t\t\tcheck-password-strength\n\t\t\t\t\t:label=\"t('settings', 'New password')\"\n\t\t\t\t\t:maxlength=\"469\"\n\t\t\t\t\tname=\"newpassword\"\n\t\t\t\t\tautocomplete=\"new-password\"\n\t\t\t\t\tautocapitalize=\"none\"\n\t\t\t\t\trequired\n\t\t\t\t\tspellcheck=\"false\" />\n\t\t\t</NcFormBox>\n\n\t\t\t<NcButton\n\t\t\t\ttype=\"submit\"\n\t\t\t\tvariant=\"primary\"\n\t\t\t\twide>\n\t\t\t\t{{ t('settings', 'Change password') }}\n\t\t\t</NcButton>\n\t\t</form>\n\t</NcSettingsSection>\n</template>\n\n<style module>\n.passwordSection__form {\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: calc(2 * var(--default-grid-baseline));\n\tmax-width: 300px !important;\n}\n</style>\n"],sourceRoot:""}]),r.locals={passwordSection__form:"_passwordSection__form_lsR4P"};const l=r},79722(t){t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},80356(t,e,n){var s=n(21777),o=n(53334),a=n(85471),r=n(19051),l=n(85168),i=n(63814),c=n(9033),d=n(32579),p=n(61744),u=n(73891),m=n(97979),g=n(57908),f=n(97453),w=n(59915),N=n(96088),h=n(15502),v=n(71711),b=n(47353),A=n(94137),x=n(47611),y=n(10363),P=n(8088),S=n(71561),_=n(54048),C=n(82752),T=n(27345),k=n(49595),F=n(78470),L=n(67485),B=n(35531),O=n(542),E=n(79810),I=n(93651),D=n(41188),j=n(71197),X=n(50017),M=n(60258),z=n(73705),R=n(48091),G=n(88022),$=n(56948),q=n(67025),U=n(68827),K=n(53135),H=n(94294),J=n(67596),Q=n(64255),V=n(48620),W=n(44221),Y=n(90429),Z=n(25833),tt=n(2465),et=n(44025),nt=n(91099),st=n(48198),ot=n(47416),at=n(39539),rt=n(83194),lt=n(11920),it=n(42507),ct=n(14421),dt=n(77221),pt=n(88368),ut=n(66317),mt=n(18177),gt=n(66768),ft=n(8633),wt=n(97398),Nt=n(51550),ht=n(93952),vt=n(66123),bt=n(48191),At=n(15441),xt=n(96717),yt=n(9313),Pt=n(88289),St=n(99759),_t=n(371),Ct=n(32991),Tt=n(47242),kt=n(35290),Ft=n(49672),Lt=n(2148),Bt=n(60945),Ot=n(36079),Et=n(97592),It=(n(34876),n(52781),n(3168),n(33116)),Dt=n(38933),jt=n(84307),Xt=(n(61338),n(71639)),Mt=n(25450),zt=n(1209),Rt=n(98222),Gt=n(87656),$t=n(24876),qt=n(33520),Ut=n(8256),Kt=n(83204),Ht=n(55471),Jt=n(64646),Qt=n(23610),Vt=(n(55581),n(94205),n(95462),n(23020),n(53429),n(23739),n(16343),n(29928),n(64660),n(18547),n(20511)),Wt=n(69885),Yt=(n(59656),n(75105),n(92471),n(16406),n(2508));c.N,d.N,p.A,u.N,m.N,g.A,f.N,w.A,h.A,v.A,b.N,N.N,A.N,x.A,y.A,P.N,S.N,_.A,C.N,T.A,k.N,F.N,L.N,B.N,O.A,E.N,I.N,D.N,D.N,j.N,X.N,M.A,z.N,R.A,G.N,Et.N,$.N,q.N,U.N,K.N,H.N,J.N,Q.N,V.N,W.N,Y.N,Z.N,tt.N,et.N,nt.default,st.A,ot.N,at.N,rt.A,lt.N,it.A,ct.N,dt.N,pt.N,ut.N,mt.N,gt.A,ft.N,wt.N,Nt.N,ht.N,vt.N,bt.N,At.N,xt.N,yt.N,Pt.A,Ot.N,St.A,_t.A,Ct.N,Tt.N,kt.N,Ft.N,Lt.N,Bt.N,Et.a,It.N,Xt.N,Dt.N,Mt.N,zt.N,Rt.N,Gt.N,$t.N,qt.N,jt.N,Ut.N,Kt.N,Ht.N,Jt.N,Qt.A,Symbol.toStringTag,Vt.A,Wt.A,Yt.yw,Symbol.toStringTag;var Zt=n(74095),te=n(16044),ee=n(88837);const ne=(0,a.pM)({__name:"PasswordSection",setup(t){const e=(0,a.KR)(),n=(0,a.KR)(""),s=(0,a.KR)("");return{__sfc:!0,passwordform:e,oldPass:n,newPass:s,changePassword:async function(){const{data:t}=await r.Ay.post((0,i.Jv)("/settings/personal/changepassword"),{oldpassword:n.value,newpassword:s.value});"error"===t.status?(0,l.Qg)(t.data.message):((0,l.Te)(t.data.message),n.value="",s.value="",e.value?.reset())},t:o.t,NcFormBox:ct.N,NcButton:Zt.A,NcPasswordField:te.A,NcSettingsSection:ee.A}}});var se=n(85072),oe=n.n(se),ae=n(97825),re=n.n(ae),le=n(77659),ie=n.n(le),ce=n(55056),de=n.n(ce),pe=n(10540),ue=n.n(pe),me=n(41113),ge=n.n(me),fe=n(66763),we={};we.styleTagTransform=ge(),we.setAttributes=de(),we.insert=ie().bind(null,"head"),we.domAPI=re(),we.insertStyleElement=ue(),oe()(fe.A,we);const Ne=fe.A&&fe.A.locals?fe.A.locals:void 0;var he=(0,n(14486).A)(ne,function(){var t=this,e=t._self._c,n=t._self._setupProxy;return e(n.NcSettingsSection,{attrs:{name:n.t("settings","Password")}},[e("form",{ref:"passwordform",class:t.$style.passwordSection__form,on:{submit:function(t){return t.preventDefault(),n.changePassword.apply(null,arguments)}}},[e(n.NcFormBox,[e(n.NcPasswordField,{attrs:{label:n.t("settings","Current password"),name:"oldpassword",autocomplete:"current-password",autocapitalize:"none",required:"",spellcheck:"false"},model:{value:n.oldPass,callback:function(t){n.oldPass=t},expression:"oldPass"}}),t._v(" "),e(n.NcPasswordField,{attrs:{"check-password-strength":"",label:n.t("settings","New password"),maxlength:469,name:"newpassword",autocomplete:"new-password",autocapitalize:"none",required:"",spellcheck:"false"},model:{value:n.newPass,callback:function(t){n.newPass=t},expression:"newPass"}})],1),t._v(" "),e(n.NcButton,{attrs:{type:"submit",variant:"primary",wide:""}},[t._v("\n\t\t\t"+t._s(n.t("settings","Change password"))+"\n\t\t")])],1)])},[],!1,function(t){this.$style=Ne.locals||Ne},null,null);const ve=he.exports;n.nc=(0,s.aV)(),a.Ay.prototype.t=o.t,a.Ay.prototype.n=o.n,new a.Ay({el:"#security-password",name:"main-personal-password",render:t=>t(ve)})}},o={};function a(t){var e=o[t];if(void 0!==e)return e.exports;var n=o[t]={id:t,loaded:!1,exports:{}};return s[t].call(n.exports,n,n.exports,a),n.loaded=!0,n.exports}a.m=s,t=[],a.O=(e,n,s,o)=>{if(!n){var r=1/0;for(d=0;d<t.length;d++){for(var[n,s,o]=t[d],l=!0,i=0;i<n.length;i++)(!1&o||r>=o)&&Object.keys(a.O).every(t=>a.O[t](n[i]))?n.splice(i--,1):(l=!1,o<r&&(r=o));if(l){t.splice(d--,1);var c=s();void 0!==c&&(e=c)}}return e}o=o||0;for(var d=t.length;d>0&&t[d-1][2]>o;d--)t[d]=t[d-1];t[d]=[n,s,o]},a.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return a.d(e,{a:e}),e},a.d=(t,e)=>{for(var n in e)a.o(e,n)&&!a.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},a.f={},a.e=t=>Promise.all(Object.keys(a.f).reduce((e,n)=>(a.f[n](t,e),e),[])),a.u=t=>t+"-"+t+".js?v="+{2710:"0c2e26891ac1c05900e0",4471:"9b3c8620f038b7593241",5862:"580b9c2e231a9169a12f",6798:"b6c47bd4c707c3e5af5b",7004:"da5a822695a273d4d2eb",7394:"5b773f16893ed80e0246",7471:"9ee6c1057cda0339f62c",7859:"cd6f48c919ca307639eb",8127:"b62d5791b2d7256af4a8",8453:"0ad2c9a35eee895d5980"}[t],a.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),e={},n="nextcloud-ui-legacy:",a.l=(t,s,o,r)=>{if(e[t])e[t].push(s);else{var l,i;if(void 0!==o)for(var c=document.getElementsByTagName("script"),d=0;d<c.length;d++){var p=c[d];if(p.getAttribute("src")==t||p.getAttribute("data-webpack")==n+o){l=p;break}}l||(i=!0,(l=document.createElement("script")).charset="utf-8",a.nc&&l.setAttribute("nonce",a.nc),l.setAttribute("data-webpack",n+o),l.src=t),e[t]=[s];var u=(n,s)=>{l.onerror=l.onload=null,clearTimeout(m);var o=e[t];if(delete e[t],l.parentNode&&l.parentNode.removeChild(l),o&&o.forEach(t=>t(s)),n)return n(s)},m=setTimeout(u.bind(null,void 0,{type:"timeout",target:l}),12e4);l.onerror=u.bind(null,l.onerror),l.onload=u.bind(null,l.onload),i&&document.head.appendChild(l)}},a.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},a.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),a.j=186,(()=>{var t;globalThis.importScripts&&(t=globalThis.location+"");var e=globalThis.document;if(!t&&e&&(e.currentScript&&"SCRIPT"===e.currentScript.tagName.toUpperCase()&&(t=e.currentScript.src),!t)){var n=e.getElementsByTagName("script");if(n.length)for(var s=n.length-1;s>-1&&(!t||!/^http(s?):/.test(t));)t=n[s--].src}if(!t)throw new Error("Automatic publicPath is not supported in this browser");t=t.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),a.p=t})(),(()=>{a.b="undefined"!=typeof document&&document.baseURI||self.location.href;var t={186:0,7471:0};a.f.j=(e,n)=>{var s=a.o(t,e)?t[e]:void 0;if(0!==s)if(s)n.push(s[2]);else{var o=new Promise((n,o)=>s=t[e]=[n,o]);n.push(s[2]=o);var r=a.p+a.u(e),l=new Error;a.l(r,n=>{if(a.o(t,e)&&(0!==(s=t[e])&&(t[e]=void 0),s)){var o=n&&("load"===n.type?"missing":n.type),r=n&&n.target&&n.target.src;l.message="Loading chunk "+e+" failed.\n("+o+": "+r+")",l.name="ChunkLoadError",l.type=o,l.request=r,s[1](l)}},"chunk-"+e,e)}},a.O.j=e=>0===t[e];var e=(e,n)=>{var s,o,[r,l,i]=n,c=0;if(r.some(e=>0!==t[e])){for(s in l)a.o(l,s)&&(a.m[s]=l[s]);if(i)var d=i(a)}for(e&&e(n);c<r.length;c++)o=r[c],a.o(t,o)&&t[o]&&t[o][0](),t[o]=0;return a.O(d)},n=globalThis.webpackChunknextcloud_ui_legacy=globalThis.webpackChunknextcloud_ui_legacy||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),a.nc=void 0;var r=a.O(void 0,[4208],()=>a(80356));r=a.O(r)})();
//# sourceMappingURL=settings-vue-settings-personal-password.js.map?v=1ec704bdd9556560a065