<?php

/**
 * SPDX-FileCopyrightText: 2017-2024 Nextcloud GmbH and Nextcloud contributors
 * SPDX-FileCopyrightText: 2016 ownCloud, Inc.
 * SPDX-License-Identifier: AGPL-3.0-only
 */
namespace OCA\Files_Sharing\ShareBackend;

use OCP\IDBConnection;
use OCP\Server;
use OCP\Share_Backend_Collection;

class Folder extends File implements Share_Backend_Collection {
	public function getChildren($itemSource): array {
		$children = [];
		$parents = [$itemSource];

		$qb = Server::get(IDBConnection::class)->getQueryBuilder();
		$qb->select('id')
			->from('mimetypes')
			->where(
				$qb->expr()->eq('mimetype', $qb->createNamedParameter('httpd/unix-directory'))
			);
		$result = $qb->executeQuery();

		if (($row = $result->fetchAssociative()) !== false) {
			$mimetype = (int)$row['id'];
		} else {
			$mimetype = -1;
		}
		$result->closeCursor();

		while (!empty($parents)) {
			$qb = Server::get(IDBConnection::class)->getQueryBuilder();

			$parents = array_map(function ($parent) use ($qb) {
				return $qb->createNamedParameter($parent);
			}, $parents);

			$qb->select('`fileid', 'name', '`mimetype')
				->from('filecache')
				->where(
					$qb->expr()->in('parent', $parents)
				);

			$result = $qb->executeQuery();

			$parents = [];
			foreach ($result->iterateAssociative() as $file) {
				$children[] = ['source' => $file['fileid'], 'file_path' => $file['name']];
				// If a child folder is found look inside it
				if ((int)$file['mimetype'] === $mimetype) {
					$parents[] = $file['fileid'];
				}
			}
			$result->closeCursor();
		}
		return $children;
	}
}
