(()=>{var e,t,n,i={15914(e,t,n){"use strict";n.d(t,{A:()=>o});var i=n(71354),r=n.n(i),s=n(76314),a=n.n(s)()(r());a.push([e.id,"\n._fileListFilterAccount_ZW91g {\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: var(--default-grid-baseline);\n}\n._fileListFilterAccount__avatar_V0YuN {\n\t/* 24px is the avatar size */\n\tmargin: calc((var(--default-clickable-area) - 24px) / 2);\n}\n._fileListFilterAccount__currentUser_PqQfx {\n\tfont-weight: normal !important;\n}\n","",{version:3,sources:["webpack://./apps/files_sharing/src/components/FileListFilterAccount.vue"],names:[],mappings:";AA4JA;CACA,aAAA;CACA,sBAAA;CACA,iCAAA;AACA;AAEA;CACA,4BAAA;CACA,wDAAA;AACA;AAEA;CACA,8BAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2024 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n<template>\n\t<div :class=\"$style.fileListFilterAccount\">\n\t\t<NcTextField\n\t\t\tv-if=\"availableAccounts.length > 1\"\n\t\t\tv-model=\"accountFilter\"\n\t\t\ttype=\"search\"\n\t\t\t:label=\"t('files_sharing', 'Filter accounts')\" />\n\t\t<NcButton\n\t\t\tv-for=\"account of shownAccounts\"\n\t\t\t:key=\"account.id\"\n\t\t\talignment=\"start\"\n\t\t\t:pressed=\"selectedAccounts.includes(account)\"\n\t\t\tvariant=\"tertiary\"\n\t\t\twide\n\t\t\t@update:pressed=\"toggleAccount(account.id, $event)\">\n\t\t\t<template #icon>\n\t\t\t\t<NcAvatar\n\t\t\t\t\t:class=\"$style.fileListFilterAccount__avatar\"\n\t\t\t\t\tv-bind=\"account\"\n\t\t\t\t\t:size=\"24\"\n\t\t\t\t\tdisable-menu\n\t\t\t\t\thide-status />\n\t\t\t</template>\n\t\t\t{{ account.displayName }}\n\t\t\t<span v-if=\"account.id === currentUserId\" :class=\"$style.fileListFilterAccount__currentUser\">\n\t\t\t\t({{ t('files', 'you') }})\n\t\t\t</span>\n\t\t</NcButton>\n\t</div>\n</template>\n\n<script setup lang=\"ts\">\nimport type { AccountFilter, IAccountData } from '../files_filters/AccountFilter.ts'\n\nimport { t } from '@nextcloud/l10n'\nimport { computed, onMounted, onUnmounted, ref, watch } from 'vue'\nimport NcAvatar from '@nextcloud/vue/components/NcAvatar'\nimport NcButton from '@nextcloud/vue/components/NcButton'\nimport NcTextField from '@nextcloud/vue/components/NcTextField'\nimport { getCurrentUser } from '../../../../core/src/OC/currentuser.js'\n\ninterface IUserSelectData {\n\tid: string\n\tuser: string\n\tdisplayName: string\n}\n\nconst props = defineProps<{\n\tfilter: AccountFilter\n}>()\n\nconst currentUserId = getCurrentUser()!.uid\n\nconst accountFilter = ref('')\nconst availableAccounts = ref<IUserSelectData[]>([])\nconst selectedAccounts = ref<IUserSelectData[]>([])\nwatch(selectedAccounts, () => {\n\tconst accounts = selectedAccounts.value.map(({ id: uid, displayName }) => ({ uid, displayName }))\n\tprops.filter.setAccounts(accounts.length > 0 ? accounts : undefined)\n})\n\nonMounted(() => {\n\tsetAvailableAccounts(props.filter.availableAccounts)\n\tselectedAccounts.value = availableAccounts.value.filter(({ id }) => props.filter.filterAccounts?.some(({ uid }) => uid === id)) ?? []\n\tprops.filter.addEventListener('accounts-updated', setAvailableAccounts)\n\tprops.filter.addEventListener('reset', resetFilter)\n\tprops.filter.addEventListener('deselect', deselect)\n})\nonUnmounted(() => {\n\tprops.filter.removeEventListener('accounts-updated', setAvailableAccounts)\n\tprops.filter.removeEventListener('reset', resetFilter)\n\tprops.filter.removeEventListener('deselect', deselect)\n})\n\n/**\n * Currently shown accounts (filtered)\n */\nconst shownAccounts = computed(() => {\n\tif (!accountFilter.value) {\n\t\treturn [...availableAccounts.value].sort(sortAccounts)\n\t}\n\n\tconst queryParts = accountFilter.value.toLocaleLowerCase().trim().split(' ')\n\tconst accounts = availableAccounts.value.filter((account) => queryParts.every((part) => account.user.toLocaleLowerCase().includes(part)\n\t\t|| account.displayName.toLocaleLowerCase().includes(part)))\n\treturn accounts.sort(sortAccounts)\n})\n\n/**\n * Sort accounts, putting the current user at the begin\n *\n * @param a - First account\n * @param b - Second account\n */\nfunction sortAccounts(a: IUserSelectData, b: IUserSelectData) {\n\tif (a.id === currentUserId) {\n\t\treturn -1\n\t}\n\tif (b.id === currentUserId) {\n\t\treturn 1\n\t}\n\treturn a.displayName.localeCompare(b.displayName)\n}\n\n/**\n * Toggle an account as selected\n *\n * @param accountId The account to toggle\n * @param selected Whether to select or deselect the account\n */\nfunction toggleAccount(accountId: string, selected: boolean) {\n\tselectedAccounts.value = selectedAccounts.value.filter(({ id }) => id !== accountId)\n\tif (selected) {\n\t\tconst account = availableAccounts.value.find(({ id }) => id === accountId)\n\t\tif (account) {\n\t\t\tselectedAccounts.value = [...selectedAccounts.value, account]\n\t\t}\n\t}\n}\n\n/**\n * Deselect an account\n *\n * @param event - The custom event\n */\nfunction deselect(event: CustomEvent) {\n\tconst accountId = event.detail as string\n\tselectedAccounts.value = selectedAccounts.value.filter(({ id }) => id !== accountId)\n}\n\n/**\n * Reset this filter\n */\nfunction resetFilter() {\n\tselectedAccounts.value = []\n\taccountFilter.value = ''\n}\n\n/**\n * Update list of available accounts in current view.\n *\n * @param accounts - Accounts to use\n */\nfunction setAvailableAccounts(accounts: IAccountData[] | CustomEvent): void {\n\tif (accounts instanceof CustomEvent) {\n\t\taccounts = accounts.detail as IAccountData[]\n\t}\n\tavailableAccounts.value = accounts.map(({ uid, displayName }) => ({ displayName, id: uid, user: uid }))\n}\n<\/script>\n\n<style module>\n.fileListFilterAccount {\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: var(--default-grid-baseline);\n}\n\n.fileListFilterAccount__avatar {\n\t/* 24px is the avatar size */\n\tmargin: calc((var(--default-clickable-area) - 24px) / 2);\n}\n\n.fileListFilterAccount__currentUser {\n\tfont-weight: normal !important;\n}\n</style>\n"],sourceRoot:""}]),a.locals={fileListFilterAccount:"_fileListFilterAccount_ZW91g",fileListFilterAccount__avatar:"_fileListFilterAccount__avatar_V0YuN",fileListFilterAccount__currentUser:"_fileListFilterAccount__currentUser_PqQfx"};const o=a},35810(e,t,n){"use strict";n.d(t,{Gg:()=>c,L3:()=>M,Ss:()=>G,Up:()=>k,Y9:()=>H,ZH:()=>i.a,aX:()=>i.P,bh:()=>z,cZ:()=>V,dC:()=>W,hY:()=>l,m9:()=>o,pt:()=>i.F,vd:()=>i.b,zj:()=>Z});var i=n(36520),r=n(380),s=n(20005),a=(n(53334),n(65606));const o=Object.freeze({DEFAULT:"default",HIDDEN:"hidden"});class l{_action;constructor(e){this.validateAction(e),this._action=e}get id(){return this._action.id}get displayName(){return this._action.displayName}get title(){return this._action.title}get iconSvgInline(){return this._action.iconSvgInline}get enabled(){return this._action.enabled}get exec(){return this._action.exec}get execBatch(){return this._action.execBatch}get hotkey(){return this._action.hotkey}get order(){return this._action.order}get parent(){return this._action.parent}get default(){return this._action.default}get destructive(){return this._action.destructive}get inline(){return this._action.inline}get renderInline(){return this._action.renderInline}validateAction(e){if(!e.id||"string"!=typeof e.id)throw new Error("Invalid id");if(!e.displayName||"function"!=typeof e.displayName)throw new Error("Invalid displayName function");if("title"in e&&"function"!=typeof e.title)throw new Error("Invalid title function");if(!e.iconSvgInline||"function"!=typeof e.iconSvgInline)throw new Error("Invalid iconSvgInline function");if(!e.exec||"function"!=typeof e.exec)throw new Error("Invalid exec function");if("enabled"in e&&"function"!=typeof e.enabled)throw new Error("Invalid enabled function");if("execBatch"in e&&"function"!=typeof e.execBatch)throw new Error("Invalid execBatch function");if("order"in e&&"number"!=typeof e.order)throw new Error("Invalid order");if(void 0!==e.destructive&&"boolean"!=typeof e.destructive)throw new Error("Invalid destructive flag");if("parent"in e&&"string"!=typeof e.parent)throw new Error("Invalid parent");if(e.default&&!Object.values(o).includes(e.default))throw new Error("Invalid default");if("inline"in e&&"function"!=typeof e.inline)throw new Error("Invalid inline function");if("renderInline"in e&&"function"!=typeof e.renderInline)throw new Error("Invalid renderInline function");if("hotkey"in e&&void 0!==e.hotkey){if("object"!=typeof e.hotkey)throw new Error("Invalid hotkey configuration");if("string"!=typeof e.hotkey.key||!e.hotkey.key)throw new Error("Missing or invalid hotkey key");if("string"!=typeof e.hotkey.description||!e.hotkey.description)throw new Error("Missing or invalid hotkey description")}}}function c(e){void 0===window._nc_fileactions&&(window._nc_fileactions=[],i.l.debug("FileActions initialized")),window._nc_fileactions.find(t=>t.id===e.id)?i.l.error(`FileAction ${e.id} already registered`,{action:e}):window._nc_fileactions.push(e)}function d(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var u,h,p,f;function w(){if(h)return u;h=1;const e="object"==typeof a&&a.env&&a.env.NODE_DEBUG&&/\bsemver\b/i.test(a.env.NODE_DEBUG)?(...e)=>console.error("SEMVER",...e):()=>{};return u=e}function g(){if(f)return p;f=1;const e=Number.MAX_SAFE_INTEGER||9007199254740991;return p={MAX_LENGTH:256,MAX_SAFE_COMPONENT_LENGTH:16,MAX_SAFE_BUILD_LENGTH:250,MAX_SAFE_INTEGER:e,RELEASE_TYPES:["major","premajor","minor","preminor","patch","prepatch","prerelease"],SEMVER_SPEC_VERSION:"2.0.0",FLAG_INCLUDE_PRERELEASE:1,FLAG_LOOSE:2}}var m,v,E,A,_,b,y,I,C,N={exports:{}};function L(){if(y)return b;y=1;const e=w(),{MAX_LENGTH:t,MAX_SAFE_INTEGER:n}=g(),{safeRe:i,t:r}=(m||(m=1,function(e,t){const{MAX_SAFE_COMPONENT_LENGTH:n,MAX_SAFE_BUILD_LENGTH:i,MAX_LENGTH:r}=g(),s=w(),a=(t=e.exports={}).re=[],o=t.safeRe=[],l=t.src=[],c=t.safeSrc=[],d=t.t={};let u=0;const h="[a-zA-Z0-9-]",p=[["\\s",1],["\\d",r],[h,i]],f=(e,t,n)=>{const i=(e=>{for(const[t,n]of p)e=e.split(`${t}*`).join(`${t}{0,${n}}`).split(`${t}+`).join(`${t}{1,${n}}`);return e})(t),r=u++;s(e,r,t),d[e]=r,l[r]=t,c[r]=i,a[r]=new RegExp(t,n?"g":void 0),o[r]=new RegExp(i,n?"g":void 0)};f("NUMERICIDENTIFIER","0|[1-9]\\d*"),f("NUMERICIDENTIFIERLOOSE","\\d+"),f("NONNUMERICIDENTIFIER",`\\d*[a-zA-Z-]${h}*`),f("MAINVERSION",`(${l[d.NUMERICIDENTIFIER]})\\.(${l[d.NUMERICIDENTIFIER]})\\.(${l[d.NUMERICIDENTIFIER]})`),f("MAINVERSIONLOOSE",`(${l[d.NUMERICIDENTIFIERLOOSE]})\\.(${l[d.NUMERICIDENTIFIERLOOSE]})\\.(${l[d.NUMERICIDENTIFIERLOOSE]})`),f("PRERELEASEIDENTIFIER",`(?:${l[d.NONNUMERICIDENTIFIER]}|${l[d.NUMERICIDENTIFIER]})`),f("PRERELEASEIDENTIFIERLOOSE",`(?:${l[d.NONNUMERICIDENTIFIER]}|${l[d.NUMERICIDENTIFIERLOOSE]})`),f("PRERELEASE",`(?:-(${l[d.PRERELEASEIDENTIFIER]}(?:\\.${l[d.PRERELEASEIDENTIFIER]})*))`),f("PRERELEASELOOSE",`(?:-?(${l[d.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${l[d.PRERELEASEIDENTIFIERLOOSE]})*))`),f("BUILDIDENTIFIER",`${h}+`),f("BUILD",`(?:\\+(${l[d.BUILDIDENTIFIER]}(?:\\.${l[d.BUILDIDENTIFIER]})*))`),f("FULLPLAIN",`v?${l[d.MAINVERSION]}${l[d.PRERELEASE]}?${l[d.BUILD]}?`),f("FULL",`^${l[d.FULLPLAIN]}$`),f("LOOSEPLAIN",`[v=\\s]*${l[d.MAINVERSIONLOOSE]}${l[d.PRERELEASELOOSE]}?${l[d.BUILD]}?`),f("LOOSE",`^${l[d.LOOSEPLAIN]}$`),f("GTLT","((?:<|>)?=?)"),f("XRANGEIDENTIFIERLOOSE",`${l[d.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`),f("XRANGEIDENTIFIER",`${l[d.NUMERICIDENTIFIER]}|x|X|\\*`),f("XRANGEPLAIN",`[v=\\s]*(${l[d.XRANGEIDENTIFIER]})(?:\\.(${l[d.XRANGEIDENTIFIER]})(?:\\.(${l[d.XRANGEIDENTIFIER]})(?:${l[d.PRERELEASE]})?${l[d.BUILD]}?)?)?`),f("XRANGEPLAINLOOSE",`[v=\\s]*(${l[d.XRANGEIDENTIFIERLOOSE]})(?:\\.(${l[d.XRANGEIDENTIFIERLOOSE]})(?:\\.(${l[d.XRANGEIDENTIFIERLOOSE]})(?:${l[d.PRERELEASELOOSE]})?${l[d.BUILD]}?)?)?`),f("XRANGE",`^${l[d.GTLT]}\\s*${l[d.XRANGEPLAIN]}$`),f("XRANGELOOSE",`^${l[d.GTLT]}\\s*${l[d.XRANGEPLAINLOOSE]}$`),f("COERCEPLAIN",`(^|[^\\d])(\\d{1,${n}})(?:\\.(\\d{1,${n}}))?(?:\\.(\\d{1,${n}}))?`),f("COERCE",`${l[d.COERCEPLAIN]}(?:$|[^\\d])`),f("COERCEFULL",l[d.COERCEPLAIN]+`(?:${l[d.PRERELEASE]})?(?:${l[d.BUILD]})?(?:$|[^\\d])`),f("COERCERTL",l[d.COERCE],!0),f("COERCERTLFULL",l[d.COERCEFULL],!0),f("LONETILDE","(?:~>?)"),f("TILDETRIM",`(\\s*)${l[d.LONETILDE]}\\s+`,!0),t.tildeTrimReplace="$1~",f("TILDE",`^${l[d.LONETILDE]}${l[d.XRANGEPLAIN]}$`),f("TILDELOOSE",`^${l[d.LONETILDE]}${l[d.XRANGEPLAINLOOSE]}$`),f("LONECARET","(?:\\^)"),f("CARETTRIM",`(\\s*)${l[d.LONECARET]}\\s+`,!0),t.caretTrimReplace="$1^",f("CARET",`^${l[d.LONECARET]}${l[d.XRANGEPLAIN]}$`),f("CARETLOOSE",`^${l[d.LONECARET]}${l[d.XRANGEPLAINLOOSE]}$`),f("COMPARATORLOOSE",`^${l[d.GTLT]}\\s*(${l[d.LOOSEPLAIN]})$|^$`),f("COMPARATOR",`^${l[d.GTLT]}\\s*(${l[d.FULLPLAIN]})$|^$`),f("COMPARATORTRIM",`(\\s*)${l[d.GTLT]}\\s*(${l[d.LOOSEPLAIN]}|${l[d.XRANGEPLAIN]})`,!0),t.comparatorTrimReplace="$1$2$3",f("HYPHENRANGE",`^\\s*(${l[d.XRANGEPLAIN]})\\s+-\\s+(${l[d.XRANGEPLAIN]})\\s*$`),f("HYPHENRANGELOOSE",`^\\s*(${l[d.XRANGEPLAINLOOSE]})\\s+-\\s+(${l[d.XRANGEPLAINLOOSE]})\\s*$`),f("STAR","(<|>)?=?\\s*\\*"),f("GTE0","^\\s*>=\\s*0\\.0\\.0\\s*$"),f("GTE0PRE","^\\s*>=\\s*0\\.0\\.0-0\\s*$")}(N,N.exports)),N.exports),s=function(){if(E)return v;E=1;const e=Object.freeze({loose:!0}),t=Object.freeze({});return v=n=>n?"object"!=typeof n?e:n:t}(),{compareIdentifiers:a}=function(){if(_)return A;_=1;const e=/^[0-9]+$/,t=(t,n)=>{if("number"==typeof t&&"number"==typeof n)return t===n?0:t<n?-1:1;const i=e.test(t),r=e.test(n);return i&&r&&(t=+t,n=+n),t===n?0:i&&!r?-1:r&&!i?1:t<n?-1:1};return A={compareIdentifiers:t,rcompareIdentifiers:(e,n)=>t(n,e)}}();class o{constructor(a,l){if(l=s(l),a instanceof o){if(a.loose===!!l.loose&&a.includePrerelease===!!l.includePrerelease)return a;a=a.version}else if("string"!=typeof a)throw new TypeError(`Invalid version. Must be a string. Got type "${typeof a}".`);if(a.length>t)throw new TypeError(`version is longer than ${t} characters`);e("SemVer",a,l),this.options=l,this.loose=!!l.loose,this.includePrerelease=!!l.includePrerelease;const c=a.trim().match(l.loose?i[r.LOOSE]:i[r.FULL]);if(!c)throw new TypeError(`Invalid Version: ${a}`);if(this.raw=a,this.major=+c[1],this.minor=+c[2],this.patch=+c[3],this.major>n||this.major<0)throw new TypeError("Invalid major version");if(this.minor>n||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>n||this.patch<0)throw new TypeError("Invalid patch version");c[4]?this.prerelease=c[4].split(".").map(e=>{if(/^[0-9]+$/.test(e)){const t=+e;if(t>=0&&t<n)return t}return e}):this.prerelease=[],this.build=c[5]?c[5].split("."):[],this.format()}format(){return this.version=`${this.major}.${this.minor}.${this.patch}`,this.prerelease.length&&(this.version+=`-${this.prerelease.join(".")}`),this.version}toString(){return this.version}compare(t){if(e("SemVer.compare",this.version,this.options,t),!(t instanceof o)){if("string"==typeof t&&t===this.version)return 0;t=new o(t,this.options)}return t.version===this.version?0:this.compareMain(t)||this.comparePre(t)}compareMain(e){return e instanceof o||(e=new o(e,this.options)),this.major<e.major?-1:this.major>e.major?1:this.minor<e.minor?-1:this.minor>e.minor?1:this.patch<e.patch?-1:this.patch>e.patch?1:0}comparePre(t){if(t instanceof o||(t=new o(t,this.options)),this.prerelease.length&&!t.prerelease.length)return-1;if(!this.prerelease.length&&t.prerelease.length)return 1;if(!this.prerelease.length&&!t.prerelease.length)return 0;let n=0;do{const i=this.prerelease[n],r=t.prerelease[n];if(e("prerelease compare",n,i,r),void 0===i&&void 0===r)return 0;if(void 0===r)return 1;if(void 0===i)return-1;if(i!==r)return a(i,r)}while(++n)}compareBuild(t){t instanceof o||(t=new o(t,this.options));let n=0;do{const i=this.build[n],r=t.build[n];if(e("build compare",n,i,r),void 0===i&&void 0===r)return 0;if(void 0===r)return 1;if(void 0===i)return-1;if(i!==r)return a(i,r)}while(++n)}inc(e,t,n){if(e.startsWith("pre")){if(!t&&!1===n)throw new Error("invalid increment argument: identifier is empty");if(t){const e=`-${t}`.match(this.options.loose?i[r.PRERELEASELOOSE]:i[r.PRERELEASE]);if(!e||e[1]!==t)throw new Error(`invalid identifier: ${t}`)}}switch(e){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",t,n);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",t,n);break;case"prepatch":this.prerelease.length=0,this.inc("patch",t,n),this.inc("pre",t,n);break;case"prerelease":0===this.prerelease.length&&this.inc("patch",t,n),this.inc("pre",t,n);break;case"release":if(0===this.prerelease.length)throw new Error(`version ${this.raw} is not a prerelease`);this.prerelease.length=0;break;case"major":0===this.minor&&0===this.patch&&0!==this.prerelease.length||this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":0===this.patch&&0!==this.prerelease.length||this.minor++,this.patch=0,this.prerelease=[];break;case"patch":0===this.prerelease.length&&this.patch++,this.prerelease=[];break;case"pre":{const e=Number(n)?1:0;if(0===this.prerelease.length)this.prerelease=[e];else{let i=this.prerelease.length;for(;--i>=0;)"number"==typeof this.prerelease[i]&&(this.prerelease[i]++,i=-2);if(-1===i){if(t===this.prerelease.join(".")&&!1===n)throw new Error("invalid increment argument: identifier already exists");this.prerelease.push(e)}}if(t){let i=[t,e];!1===n&&(i=[t]),0===a(this.prerelease[0],t)?isNaN(this.prerelease[1])&&(this.prerelease=i):this.prerelease=i}break}default:throw new Error(`invalid increment argument: ${e}`)}return this.raw=this.format(),this.build.length&&(this.raw+=`+${this.build.join(".")}`),this}}return b=o}const S=d(function(){if(C)return I;C=1;const e=L();return I=(t,n)=>new e(t,n).major}());var R,O,T,x;const $=d(function(){if(x)return T;x=1;const e=function(){if(O)return R;O=1;const e=L();return R=(t,n,i=!1)=>{if(t instanceof e)return t;try{return new e(t,n)}catch(e){if(!i)return null;throw e}}}();return T=(t,n)=>{const i=e(t,n);return i?i.version:null}}());class D{bus;constructor(e){"function"==typeof e.getVersion&&$(e.getVersion())?S(e.getVersion())!==S(this.getVersion())&&console.warn("Proxying an event bus of version "+e.getVersion()+" with "+this.getVersion()):console.warn("Proxying an event bus with an unknown or invalid version"),this.bus=e}getVersion(){return"3.3.3"}subscribe(e,t){this.bus.subscribe(e,t)}unsubscribe(e,t){this.bus.unsubscribe(e,t)}emit(e,...t){this.bus.emit(e,...t)}}class F{handlers=new Map;getVersion(){return"3.3.3"}subscribe(e,t){this.handlers.set(e,(this.handlers.get(e)||[]).concat(t))}unsubscribe(e,t){this.handlers.set(e,(this.handlers.get(e)||[]).filter(e=>e!==t))}emit(e,...t){(this.handlers.get(e)||[]).forEach(e=>{try{e(t[0])}catch(e){console.error("could not invoke event listener",e)}})}}let P=null;class M extends r.m{id;order;constructor(e,t=100){super(),this.id=e,this.order=t}filter(e){throw new Error("Not implemented")}updateChips(e){this.dispatchTypedEvent("update:chips",new CustomEvent("update:chips",{detail:e}))}filterUpdated(){this.dispatchTypedEvent("update:filter",new CustomEvent("update:filter"))}}function V(e){if(window._nc_filelist_filters||(window._nc_filelist_filters=new Map),window._nc_filelist_filters.has(e.id))throw new Error(`File list filter "${e.id}" already registered`);window._nc_filelist_filters.set(e.id,e),function(e,...t){(null!==P?P:"undefined"==typeof window?new Proxy({},{get:()=>()=>console.error("Window not available, EventBus can not be established!")}):(window.OC?._eventBus&&void 0===window._nc_event_bus&&(console.warn("found old event bus instance at OC._eventBus. Update your version!"),window._nc_event_bus=window.OC._eventBus),P=void 0!==window?._nc_event_bus?new D(window._nc_event_bus):window._nc_event_bus=new F,P)).emit(e,...t)}("files:filter:added",e)}class H{_header;constructor(e){this.validateHeader(e),this._header=e}get id(){return this._header.id}get order(){return this._header.order}get enabled(){return this._header.enabled}get render(){return this._header.render}get updated(){return this._header.updated}validateHeader(e){if(!e.id||!e.render||!e.updated)throw new Error("Invalid header: id, render and updated are required");if("string"!=typeof e.id)throw new Error("Invalid id property");if(void 0!==e.enabled&&"function"!=typeof e.enabled)throw new Error("Invalid enabled property");if(e.render&&"function"!=typeof e.render)throw new Error("Invalid render property");if(e.updated&&"function"!=typeof e.updated)throw new Error("Invalid updated property")}}function k(e){void 0===window._nc_filelistheader&&(window._nc_filelistheader=[],i.l.debug("FileListHeaders initialized")),window._nc_filelistheader.find(t=>t.id===e.id)?i.l.error(`Header ${e.id} already registered`,{header:e}):window._nc_filelistheader.push(e)}function U(e,t,n){if(void 0!==e[t])if("array"===n){if(!Array.isArray(e[t]))throw new Error(`View ${t} must be an array`)}else{if(typeof e[t]!==n)throw new Error(`View ${t} must be a ${n}`);if("object"===n&&(null===e[t]||Array.isArray(e[t])))throw new Error(`View ${t} must be an object`)}}function j(e){if("object"!=typeof e||null===e)throw new Error("View column must be an object");if(!e.id||"string"!=typeof e.id)throw new Error("A column id is required");if(!e.title||"string"!=typeof e.title)throw new Error("A column title is required");if(!e.render||"function"!=typeof e.render)throw new Error("A render function is required");U(e,"sort","function"),U(e,"summary","function")}class G{_view;constructor(e){B(e),this._view=e}get id(){return this._view.id}get name(){return this._view.name}get caption(){return this._view.caption}get emptyTitle(){return this._view.emptyTitle}get emptyCaption(){return this._view.emptyCaption}get getContents(){return this._view.getContents}get hidden(){return this._view.hidden}get icon(){return this._view.icon}set icon(e){this._view.icon=e}get order(){return this._view.order}set order(e){this._view.order=e}get params(){return this._view.params}set params(e){this._view.params=e}get columns(){return this._view.columns}get emptyView(){return this._view.emptyView}get parent(){return this._view.parent}get sticky(){return this._view.sticky}get expanded(){return this._view.expanded}set expanded(e){this._view.expanded=e}get defaultSortKey(){return this._view.defaultSortKey}get loadChildViews(){return this._view.loadChildViews}}function B(e){if(!e.icon||"string"!=typeof e.icon||!(0,s.A)(e.icon))throw new Error("View icon is required and must be a valid svg string");if(!e.id||"string"!=typeof e.id)throw new Error("View id is required and must be a string");if(!e.getContents||"function"!=typeof e.getContents)throw new Error("View getContents is required and must be a function");if(!e.name||"string"!=typeof e.name)throw new Error("View name is required and must be a string");if(U(e,"caption","string"),U(e,"columns","array"),U(e,"defaultSortKey","string"),U(e,"emptyCaption","string"),U(e,"emptyTitle","string"),U(e,"emptyView","function"),U(e,"expanded","boolean"),U(e,"hidden","boolean"),U(e,"loadChildViews","function"),U(e,"order","number"),U(e,"params","object"),U(e,"parent","string"),U(e,"sticky","boolean"),e.columns&&(e.columns.forEach(j),e.columns.reduce((e,t)=>e.add(t.id),new Set).size!==e.columns.length))throw new Error("View columns must have unique ids")}class X extends r.m{_views=[];_currentView=null;register(e){if(this._views.find(t=>t.id===e.id))throw new Error(`IView id ${e.id} is already registered`);B(e),this._views.push(e),this.dispatchTypedEvent("update",new CustomEvent("update"))}remove(e){const t=this._views.findIndex(t=>t.id===e);-1!==t&&(this._views.splice(t,1),this.dispatchTypedEvent("update",new CustomEvent("update")))}setActive(e){if(null===e)this._currentView=null;else{const t=this._views.find(({id:t})=>t===e);if(!t)throw new Error(`No view with ${e} registered`);this._currentView=t}const t=new CustomEvent("updateActive",{detail:this._currentView});this.dispatchTypedEvent("updateActive",t)}get active(){return this._currentView}get views(){return this._views}}function z(){return void 0===window._nc_navigation&&(window._nc_navigation=new X,i.l.debug("Navigation service initialized")),window._nc_navigation}const q=Object.freeze({UploadFromDevice:0,CreateNew:1,Other:2});class Y{_entries=[];registerEntry(e){this.validateEntry(e),e.category=e.category??q.CreateNew,this._entries.push(e)}unregisterEntry(e){const t="string"==typeof e?this.getEntryIndex(e):this.getEntryIndex(e.id);-1!==t?this._entries.splice(t,1):i.l.warn("Entry not found, nothing removed",{entry:e,entries:this.getEntries()})}getEntries(e){return e?this._entries.filter(t=>"function"!=typeof t.enabled||t.enabled(e)):this._entries}getEntryIndex(e){return this._entries.findIndex(t=>t.id===e)}validateEntry(e){if(!(e.id&&e.displayName&&e.iconSvgInline&&e.handler))throw new Error("Invalid entry");if("string"!=typeof e.id||"string"!=typeof e.displayName)throw new Error("Invalid id or displayName property");if(e.iconSvgInline&&"string"!=typeof e.iconSvgInline)throw new Error("Invalid icon provided");if(void 0!==e.enabled&&"function"!=typeof e.enabled)throw new Error("Invalid enabled property");if("function"!=typeof e.handler)throw new Error("Invalid handler property");if("order"in e&&"number"!=typeof e.order)throw new Error("Invalid order property");if(-1!==this.getEntryIndex(e.id))throw new Error("Duplicate entry")}}function Z(e){return(void 0===window._nc_newfilemenu&&(window._nc_newfilemenu=new Y,i.l.debug("NewFileMenu initialized")),window._nc_newfilemenu).registerEntry(e)}class K{get#e(){return window.OCA?.Files?._sidebar?.()}get available(){return!!this.#e}get isOpen(){return this.#e?.isOpen??!1}get activeTab(){return this.#e?.activeTab}get node(){return this.#e?.node}open(e,t){this.#e?.open(e,t)}close(){this.#e?.close()}setActiveTab(e){this.#e?.setActiveTab(e)}registerTab(e){!function(e){!function(e){if("object"!=typeof e)throw new Error("Sidebar tab is not an object");if(!e.id||"string"!=typeof e.id||e.id!==CSS.escape(e.id))throw new Error("Sidebar tabs need to have an id conforming to the HTML id attribute specifications");if(!e.tagName||"string"!=typeof e.tagName)throw new Error("Sidebar tabs need to have the tagName name set");if(!e.tagName.match(/^[a-z][a-z0-9-_]+$/))throw new Error('Sidebar tab "tagName" is invalid');if(!e.displayName||"string"!=typeof e.displayName)throw new Error("Sidebar tabs need to have a name set");if("string"!=typeof e.iconSvgInline||!(0,s.A)(e.iconSvgInline))throw new Error("Sidebar tabs need to have an valid SVG icon");if("number"!=typeof e.order)throw new Error("Sidebar tabs need to have a numeric order set");if(e.enabled&&"function"!=typeof e.enabled)throw new Error('Sidebar tab "enabled" is not a function');if(e.onInit&&"function"!=typeof e.onInit)throw new Error('Sidebar tab "onInit" is not a function')}(e),window._nc_files_sidebar_tabs??=new Map,window._nc_files_sidebar_tabs.has(e.id)?i.l.warn(`Sidebar tab with id "${e.id}" already registered. Skipping.`):(window._nc_files_sidebar_tabs.set(e.id,e),i.l.debug(`New sidebar tab with id "${e.id}" registered.`))}(e)}getTabs(e){return this.#e?.getTabs(e)??[]}getActions(e){return this.#e?.getActions(e)??[]}registerAction(e){!function(e){!function(e){if("object"!=typeof e)throw new Error("Sidebar action is not an object");if(!e.id||"string"!=typeof e.id||e.id!==CSS.escape(e.id))throw new Error("Sidebar actions need to have an id conforming to the HTML id attribute specifications");if(!e.displayName||"function"!=typeof e.displayName)throw new Error("Sidebar actions need to have a displayName function");if(!e.iconSvgInline||"function"!=typeof e.iconSvgInline)throw new Error("Sidebar actions need to have a iconSvgInline function");if(!e.enabled||"function"!=typeof e.enabled)throw new Error("Sidebar actions need to have an enabled function");if(!e.onClick||"function"!=typeof e.onClick)throw new Error("Sidebar actions need to have an onClick function")}(e),window._nc_files_sidebar_actions??=new Map,window._nc_files_sidebar_actions.has(e.id)?i.l.warn(`Sidebar action with id "${e.id}" already registered. Skipping.`):(window._nc_files_sidebar_actions.set(e.id,e),i.l.debug(`New sidebar action with id "${e.id}" registered.`))}(e)}}function W(){return new K}Object.freeze({ReservedName:"reserved name",Character:"character",Extension:"extension"}),Error,Object.freeze({Name:"basename",Modified:"mtime",Size:"size"})},48564(e,t,n){"use strict";n.d(t,{A:()=>i});const i=(0,n(35947).YK)().setApp("files_sharing").detectUser().build()},53168(e,t,n){"use strict";n.d(t,{A:()=>o});var i=n(71354),r=n.n(i),s=n(76314),a=n.n(s)()(r());a.push([e.id,".action-items>.files-list__row-action-sharing-status{padding-inline:0 !important}.action-items>.files-list__row-action-sharing-status .button-vue__wrapper{flex-direction:row-reverse;gap:var(--default-grid-baseline)}svg.sharing-status__avatar{height:var(--button-inner-size, 32px) !important;width:var(--button-inner-size, 32px) !important;max-height:var(--button-inner-size, 32px) !important;max-width:var(--button-inner-size, 32px) !important;border-radius:var(--button-inner-size, 32px);overflow:hidden}.files-list__row-action-sharing-status .button-vue__text{color:var(--color-primary-element)}.files-list__row-action-sharing-status .button-vue__icon{color:var(--color-primary-element)}","",{version:3,sources:["webpack://./apps/files_sharing/src/files_actions/sharingStatusAction.scss"],names:[],mappings:"AAKA,qDAEC,2BAAA,CAEA,0EAEC,0BAAA,CACA,gCAAA,CAIF,2BACC,gDAAA,CACA,+CAAA,CACA,oDAAA,CACA,mDAAA,CACA,4CAAA,CACA,eAAA,CAIA,yDACC,kCAAA,CAED,yDACC,kCAAA",sourcesContent:["/**\n * SPDX-FileCopyrightText: 2023 Nextcloud GmbH and Nextcloud contributors\n * SPDX-License-Identifier: AGPL-3.0-or-later\n */\n // Only when rendered inline, when not enough space, this is put in the menu\n.action-items > .files-list__row-action-sharing-status {\n\t// align icons with text-less inline actions\n\tpadding-inline: 0 !important;\n\n\t.button-vue__wrapper {\n\t\t// put icon at the end of the button\n\t\tflex-direction: row-reverse;\n\t\tgap: var(--default-grid-baseline);\n\t}\n}\n\nsvg.sharing-status__avatar {\n\theight: var(--button-inner-size, 32px) !important;\n\twidth: var(--button-inner-size, 32px) !important;\n\tmax-height: var(--button-inner-size, 32px) !important;\n\tmax-width: var(--button-inner-size, 32px) !important;\n\tborder-radius: var(--button-inner-size, 32px);\n\toverflow: hidden;\n}\n\n.files-list__row-action-sharing-status {\n\t.button-vue__text {\n\t\tcolor: var(--color-primary-element);\n\t}\n\t.button-vue__icon {\n\t\tcolor: var(--color-primary-element);\n\t}\n}\n"],sourceRoot:""}]);const o=a},63779(){},77199(){},77815(e,t,n){"use strict";n.d(t,{EY:()=>u,Yc:()=>c,ei:()=>d});var i=n(21777),r=n(63814),s=n(32505),a=(n(44719),n(36520));const o=["d:getcontentlength","d:getcontenttype","d:getetag","d:getlastmodified","d:creationdate","d:displayname","d:quota-available-bytes","d:resourcetype","nc:has-preview","nc:is-encrypted","nc:mount-type","oc:comments-unread","oc:favorite","oc:fileid","oc:owner-display-name","oc:owner-id","oc:permissions","oc:size"],l={d:"DAV:",nc:"http://nextcloud.org/ns",oc:"http://owncloud.org/ns",ocs:"http://open-collaboration-services.org/ns"};function c(e,t={nc:"http://nextcloud.org/ns"}){void 0===window._nc_dav_properties&&(window._nc_dav_properties=[...o],window._nc_dav_namespaces={...l});const n={...window._nc_dav_namespaces,...t};return window._nc_dav_properties.find(t=>t===e)?(a.l.warn(`${e} already registered`,{prop:e}),!1):e.startsWith("<")||2!==e.split(":").length?(a.l.error(`${e} is not valid. See example: 'oc:fileid'`,{prop:e}),!1):n[e.split(":")[0]]?(window._nc_dav_properties.push(e),window._nc_dav_namespaces=n,!0):(a.l.error(`${e} namespace unknown`,{prop:e,namespaces:n}),!1)}function d(){return(0,s.f)()?`/files/${(0,s.G)()}`:`/files/${(0,i.HW)()?.uid}`}function u(){const e=(0,r.dC)("dav");return(0,s.f)()?e.replace("remote.php","public.php"):e}d(),u()},81382(e,t,n){"use strict";var i=n(35810),r=n(77815),s=n(61338),a=n(53334),o=n(40715),l=n(32505),c=n(26422),d=n(85471),u=n(41944),h=n(74095),p=n(82182);const f=document.getElementsByTagName("head")[0].getAttribute("data-user"),w=(document.getElementsByTagName("head")[0].getAttribute("data-user-displayname"),void 0!==f&&f),g=(0,d.pM)({__name:"FileListFilterAccount",props:{filter:null},setup(e){const t=e,n=w,i=(0,d.KR)(""),r=(0,d.KR)([]),s=(0,d.KR)([]);(0,d.wB)(s,()=>{const e=s.value.map(({id:e,displayName:t})=>({uid:e,displayName:t}));t.filter.setAccounts(e.length>0?e:void 0)}),(0,d.sV)(()=>{g(t.filter.availableAccounts),s.value=r.value.filter(({id:e})=>t.filter.filterAccounts?.some(({uid:t})=>t===e))??[],t.filter.addEventListener("accounts-updated",g),t.filter.addEventListener("reset",f),t.filter.addEventListener("deselect",c)}),(0,d.hi)(()=>{t.filter.removeEventListener("accounts-updated",g),t.filter.removeEventListener("reset",f),t.filter.removeEventListener("deselect",c)});const o=(0,d.EW)(()=>{if(!i.value)return[...r.value].sort(l);const e=i.value.toLocaleLowerCase().trim().split(" ");return r.value.filter(t=>e.every(e=>t.user.toLocaleLowerCase().includes(e)||t.displayName.toLocaleLowerCase().includes(e))).sort(l)});function l(e,t){return e.id===n?-1:t.id===n?1:e.displayName.localeCompare(t.displayName)}function c(e){const t=e.detail;s.value=s.value.filter(({id:e})=>e!==t)}function f(){s.value=[],i.value=""}function g(e){e instanceof CustomEvent&&(e=e.detail),r.value=e.map(({uid:e,displayName:t})=>({displayName:t,id:e,user:e}))}return{__sfc:!0,props:t,currentUserId:n,accountFilter:i,availableAccounts:r,selectedAccounts:s,shownAccounts:o,sortAccounts:l,toggleAccount:function(e,t){if(s.value=s.value.filter(({id:t})=>t!==e),t){const t=r.value.find(({id:t})=>t===e);t&&(s.value=[...s.value,t])}},deselect:c,resetFilter:f,setAvailableAccounts:g,t:a.t,NcAvatar:u.A,NcButton:h.A,NcTextField:p.A}}});var m=n(85072),v=n.n(m),E=n(97825),A=n.n(E),_=n(77659),b=n.n(_),y=n(55056),I=n.n(y),C=n(10540),N=n.n(C),L=n(41113),S=n.n(L),R=n(15914),O={};O.styleTagTransform=S(),O.setAttributes=I(),O.insert=b().bind(null,"head"),O.domAPI=A(),O.insertStyleElement=N(),v()(R.A,O);const T=R.A&&R.A.locals?R.A.locals:void 0,x=(0,n(14486).A)(g,function(){var e=this,t=e._self._c,n=e._self._setupProxy;return t("div",{class:e.$style.fileListFilterAccount},[n.availableAccounts.length>1?t(n.NcTextField,{attrs:{type:"search",label:n.t("files_sharing","Filter accounts")},model:{value:n.accountFilter,callback:function(e){n.accountFilter=e},expression:"accountFilter"}}):e._e(),e._v(" "),e._l(n.shownAccounts,function(i){return t(n.NcButton,{key:i.id,attrs:{alignment:"start",pressed:n.selectedAccounts.includes(i),variant:"tertiary",wide:""},on:{"update:pressed":function(e){return n.toggleAccount(i.id,e)}},scopedSlots:e._u([{key:"icon",fn:function(){return[t(n.NcAvatar,e._b({class:e.$style.fileListFilterAccount__avatar,attrs:{size:24,"disable-menu":"","hide-status":""}},"NcAvatar",i,!1))]},proxy:!0}],null,!0)},[e._v("\n\t\t"+e._s(i.displayName)+"\n\t\t"),i.id===n.currentUserId?t("span",{class:e.$style.fileListFilterAccount__currentUser},[e._v("\n\t\t\t("+e._s(n.t("files","you"))+")\n\t\t")]):e._e()])})],2)},[],!1,function(e){this.$style=T.locals||T},null,null).exports;function $(e,t,n){return(t=function(e){var t=function(e){if("object"!=typeof e||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var n=t.call(e,"string");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function D(e,t,n){(function(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")})(e,t),t.set(e,n)}function F(e,t){return e.get(M(e,t))}function P(e,t,n){return e.set(M(e,t),n),n}function M(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}const V="files_sharing-file-list-filter-account";var H=new WeakMap,k=new WeakMap;class U extends i.L3{constructor(){super("files_sharing:account",100),D(this,H,void 0),D(this,k,void 0),$(this,"displayName",(0,a.t)("files_sharing","People")),$(this,"iconSvgInline",'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-account-multiple-outline" viewBox="0 0 24 24"><path d="M13.07 10.41A5 5 0 0 0 13.07 4.59A3.39 3.39 0 0 1 15 4A3.5 3.5 0 0 1 15 11A3.39 3.39 0 0 1 13.07 10.41M5.5 7.5A3.5 3.5 0 1 1 9 11A3.5 3.5 0 0 1 5.5 7.5M7.5 7.5A1.5 1.5 0 1 0 9 6A1.5 1.5 0 0 0 7.5 7.5M16 17V19H2V17S2 13 9 13 16 17 16 17M14 17C13.86 16.22 12.67 15 9 15S4.07 16.31 4 17M15.95 13A5.32 5.32 0 0 1 18 17V19H22V17S22 13.37 15.94 13Z" /></svg>'),$(this,"tagName",V),P(H,this,[]),(0,s.B1)("files:list:updated",({contents:e})=>{this.updateAvailableAccounts(e)})}get availableAccounts(){return F(H,this)}get filterAccounts(){return F(k,this)}filter(e){if(!F(k,this)||0===F(k,this).length)return e;const t=F(k,this).map(({uid:e})=>e);return e.filter(e=>{if("trashbin"===window.OCP.Files.Router.params.view){const n=e.attributes?.["trashbin-deleted-by-id"];return!(!n||!t.includes(n))}if(e.owner&&t.includes(e.owner))return!0;const n=e.attributes.sharees?.sharee;return!(!n||![n].flat().some(({id:e})=>t.includes(e)))||!e.owner&&!n})}reset(){this.dispatchEvent(new CustomEvent("reset"))}setAccounts(e){P(k,this,e);let t=[];F(k,this)&&F(k,this).length>0&&(t=F(k,this).map(({displayName:e,uid:t})=>({text:e,user:t,onclick:()=>this.dispatchEvent(new CustomEvent("deselect",{detail:t}))}))),this.updateChips(t),this.filterUpdated()}updateAvailableAccounts(e){const t=new Map;for(const n of e){const e=n.owner;e&&!t.has(e)&&t.set(e,{uid:e,displayName:n.attributes["owner-display-name"]??n.owner});const i=[n.attributes.sharees?.sharee].flat().filter(Boolean);for(const e of[i].flat())""!==e.id&&(e.type!==o.I.User&&e.type!==o.I.Remote||t.has(e.id)||t.set(e.id,{uid:e.id,displayName:e["display-name"]}));const r=n.attributes?.["trashbin-deleted-by-id"];r&&t.set(r,{uid:r,displayName:n.attributes?.["trashbin-deleted-by-display-name"]||r})}P(H,this,[...t.values()]),this.dispatchEvent(new CustomEvent("accounts-updated"))}}const j='<svg xmlns="http://www.w3.org/2000/svg" id="mdi-file-upload-outline" viewBox="0 0 24 24"><path d="M14,2L20,8V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V4A2,2 0 0,1 6,2H14M18,20V9H13V4H6V20H18M12,12L16,16H13.5V19H10.5V16H8L12,12Z" /></svg>';var G=n(98469);const B=new(n(87771).A),X=(0,d.$V)(()=>Promise.all([n.e(4208),n.e(1598)]).then(n.bind(n,11598))),z={id:"file-request",displayName:(0,a.t)("files_sharing","Create file request"),iconSvgInline:j,order:10,enabled:()=>!(0,l.f)()&&!!B.isPublicUploadEnabled&&B.isPublicShareAllowed,async handler(e,t){(0,G.S)(X,{context:e,content:t})}},q='<svg xmlns="http://www.w3.org/2000/svg" id="mdi-account-group-outline" viewBox="0 0 24 24"><path d="M12,5A3.5,3.5 0 0,0 8.5,8.5A3.5,3.5 0 0,0 12,12A3.5,3.5 0 0,0 15.5,8.5A3.5,3.5 0 0,0 12,5M12,7A1.5,1.5 0 0,1 13.5,8.5A1.5,1.5 0 0,1 12,10A1.5,1.5 0 0,1 10.5,8.5A1.5,1.5 0 0,1 12,7M5.5,8A2.5,2.5 0 0,0 3,10.5C3,11.44 3.53,12.25 4.29,12.68C4.65,12.88 5.06,13 5.5,13C5.94,13 6.35,12.88 6.71,12.68C7.08,12.47 7.39,12.17 7.62,11.81C6.89,10.86 6.5,9.7 6.5,8.5C6.5,8.41 6.5,8.31 6.5,8.22C6.2,8.08 5.86,8 5.5,8M18.5,8C18.14,8 17.8,8.08 17.5,8.22C17.5,8.31 17.5,8.41 17.5,8.5C17.5,9.7 17.11,10.86 16.38,11.81C16.5,12 16.63,12.15 16.78,12.3C16.94,12.45 17.1,12.58 17.29,12.68C17.65,12.88 18.06,13 18.5,13C18.94,13 19.35,12.88 19.71,12.68C20.47,12.25 21,11.44 21,10.5A2.5,2.5 0 0,0 18.5,8M12,14C9.66,14 5,15.17 5,17.5V19H19V17.5C19,15.17 14.34,14 12,14M4.71,14.55C2.78,14.78 0,15.76 0,17.5V19H3V17.07C3,16.06 3.69,15.22 4.71,14.55M19.29,14.55C20.31,15.22 21,16.06 21,17.07V19H24V17.5C24,15.76 21.22,14.78 19.29,14.55M12,16C13.53,16 15.24,16.5 16.23,17H7.77C8.76,16.5 10.47,16 12,16Z" /></svg>',Y='<svg xmlns="http://www.w3.org/2000/svg" id="mdi-account-plus-outline" viewBox="0 0 24 24"><path d="M15,4A4,4 0 0,0 11,8A4,4 0 0,0 15,12A4,4 0 0,0 19,8A4,4 0 0,0 15,4M15,5.9C16.16,5.9 17.1,6.84 17.1,8C17.1,9.16 16.16,10.1 15,10.1A2.1,2.1 0 0,1 12.9,8A2.1,2.1 0 0,1 15,5.9M4,7V10H1V12H4V15H6V12H9V10H6V7H4M15,13C12.33,13 7,14.33 7,17V20H23V17C23,14.33 17.67,13 15,13M15,14.9C17.97,14.9 21.1,16.36 21.1,17V18.1H8.9V17C8.9,16.36 12,14.9 15,14.9Z" /></svg>',Z='<svg xmlns="http://www.w3.org/2000/svg" id="mdi-link" viewBox="0 0 24 24"><path d="M3.9,12C3.9,10.29 5.29,8.9 7,8.9H11V7H7A5,5 0 0,0 2,12A5,5 0 0,0 7,17H11V15.1H7C5.29,15.1 3.9,13.71 3.9,12M8,13H16V11H8V13M17,7H13V8.9H17C18.71,8.9 20.1,10.29 20.1,12C20.1,13.71 18.71,15.1 17,15.1H13V17H17A5,5 0 0,0 22,12A5,5 0 0,0 17,7Z" /></svg>';var K=n(81222),W=n(87543);const J="shareoverview",Q="sharingin",ee="sharingout",te="sharinglinks",ne="deletedshares",ie="pendingshares";var re=n(65659),se=n(19051),ae=n(63814);const oe=new i.hY({id:"accept-share",displayName:({nodes:e})=>(0,a.zw)("files_sharing","Accept share","Accept shares",e.length),iconSvgInline:()=>re,enabled:({nodes:e,view:t})=>e.length>0&&t.id===ie,async exec({nodes:e}){try{const t=e[0],n=!!t.attributes.remote,i=(0,ae.KT)("apps/files_sharing/api/v1/{shareBase}/pending/{id}",{shareBase:n?"remote_shares":"shares",id:t.attributes.id});return await se.Ay.post(i),(0,s.Ic)("files:node:deleted",t),!0}catch{return!1}},async execBatch({nodes:e,view:t,folder:n,contents:i}){return Promise.all(e.map(e=>this.exec({nodes:[e],view:t,folder:n,contents:i})))},order:1,inline:()=>!0});(0,i.Gg)(oe);const le=new i.hY({id:"files_sharing:open-in-files",displayName:()=>(0,a.Tl)("files_sharing","Open in Files"),iconSvgInline:()=>"",enabled:({view:e})=>[J,Q,ee,te].includes(e.id),async exec({nodes:e}){const t=e[0].type===i.pt.Folder;return window.OCP.Files.Router.goToRoute(null,{view:"files",fileid:String(e[0].fileid)},{dir:t?e[0].path:e[0].dirname,openfile:t?void 0:"true"}),null},order:-1e3,default:i.m9.HIDDEN});(0,i.Gg)(le);const ce=new i.hY({id:"reject-share",displayName:({nodes:e})=>(0,a.zw)("files_sharing","Reject share","Reject shares",e.length),iconSvgInline:()=>'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-close" viewBox="0 0 24 24"><path d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z" /></svg>',enabled:({nodes:e,view:t})=>t.id===ie&&0!==e.length&&!e.some(e=>e.attributes.remote_id&&e.attributes.share_type===o.I.RemoteGroup),async exec({nodes:e}){try{const t=e[0],n=t.attributes.remote?"remote_shares":"shares",i=t.attributes.id;let r;return r=0===t.attributes.accepted?(0,ae.KT)("apps/files_sharing/api/v1/{shareBase}/pending/{id}",{shareBase:n,id:i}):(0,ae.KT)("apps/files_sharing/api/v1/{shareBase}/{id}",{shareBase:n,id:i}),await se.Ay.delete(r),(0,s.Ic)("files:node:deleted",t),!0}catch{return!1}},async execBatch({nodes:e,view:t,folder:n,contents:i}){return Promise.all(e.map(e=>this.exec({nodes:[e],view:t,folder:n,contents:i})))},order:2,inline:()=>!0});(0,i.Gg)(ce);const de=new i.hY({id:"restore-share",displayName:({nodes:e})=>(0,a.zw)("files_sharing","Restore share","Restore shares",e.length),iconSvgInline:()=>'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-arrow-u-left-top" viewBox="0 0 24 24"><path d="M20 13.5C20 17.09 17.09 20 13.5 20H6V18H13.5C16 18 18 16 18 13.5S16 9 13.5 9H7.83L10.91 12.09L9.5 13.5L4 8L9.5 2.5L10.92 3.91L7.83 7H13.5C17.09 7 20 9.91 20 13.5Z" /></svg>',enabled:({nodes:e,view:t})=>e.length>0&&t.id===ne,async exec({nodes:e}){try{const t=e[0],n=(0,ae.KT)("apps/files_sharing/api/v1/deletedshares/{id}",{id:t.attributes.id});return await se.Ay.post(n),(0,s.Ic)("files:node:deleted",t),!0}catch{return!1}},async execBatch({nodes:e,view:t,folder:n,contents:i}){return Promise.all(e.map(e=>this.exec({nodes:[e],view:t,folder:n,contents:i})))},order:1,inline:()=>!0});(0,i.Gg)(de);var ue=n(21777),he=n(85168);var pe=n(53168),fe={};function we(e){return e.attributes?.["is-federated"]??!1}fe.styleTagTransform=S(),fe.setAttributes=I(),fe.insert=b().bind(null,"head"),fe.domAPI=A(),fe.insertStyleElement=N(),v()(pe.A,fe),pe.A&&pe.A.locals&&pe.A.locals;const ge=new i.hY({id:"sharing-status",displayName({nodes:e}){const t=e[0];return Object.values(t?.attributes?.["share-types"]||{}).flat().length>0||t.owner!==(0,ue.HW)()?.uid||we(t)?(0,a.Tl)("files_sharing","Shared"):""},title({nodes:e}){const t=e[0];if(t.owner&&(t.owner!==(0,ue.HW)()?.uid||we(t))){const e=t?.attributes?.["owner-display-name"];return(0,a.Tl)("files_sharing","Shared by {ownerDisplayName}",{ownerDisplayName:e})}if(Object.values(t?.attributes?.["share-types"]||{}).flat().length>1)return(0,a.Tl)("files_sharing","Shared multiple times with different people");const n=t.attributes.sharees?.sharee;if(!n)return(0,a.Tl)("files_sharing","Sharing options");const i=[n].flat()[0];switch(i?.type){case o.I.User:return(0,a.Tl)("files_sharing","Shared with {user}",{user:i["display-name"]});case o.I.Group:return(0,a.Tl)("files_sharing","Shared with group {group}",{group:i["display-name"]??i.id});default:return(0,a.Tl)("files_sharing","Shared with others")}},iconSvgInline({nodes:e}){const t=e[0],n=Object.values(t?.attributes?.["share-types"]||{}).flat();return Array.isArray(t.attributes?.["share-types"])&&t.attributes?.["share-types"].length>1?Y:n.includes(o.I.Link)||n.includes(o.I.Email)?Z:n.includes(o.I.Group)||n.includes(o.I.RemoteGroup)?q:n.includes(o.I.Team)?'<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12,5.5A3.5,3.5 0 0,1 15.5,9A3.5,3.5 0 0,1 12,12.5A3.5,3.5 0 0,1 8.5,9A3.5,3.5 0 0,1 12,5.5M5,8C5.56,8 6.08,8.15 6.53,8.42C6.38,9.85 6.8,11.27 7.66,12.38C7.16,13.34 6.16,14 5,14A3,3 0 0,1 2,11A3,3 0 0,1 5,8M19,8A3,3 0 0,1 22,11A3,3 0 0,1 19,14C17.84,14 16.84,13.34 16.34,12.38C17.2,11.27 17.62,9.85 17.47,8.42C17.92,8.15 18.44,8 19,8M5.5,18.25C5.5,16.18 8.41,14.5 12,14.5C15.59,14.5 18.5,16.18 18.5,18.25V20H5.5V18.25M0,20V18.5C0,17.11 1.89,15.94 4.45,15.6C3.86,16.28 3.5,17.22 3.5,18.25V20H0M24,20H20.5V18.25C20.5,17.22 20.14,16.28 19.55,15.6C22.11,15.94 24,17.11 24,18.5V20Z" /></svg>':t.owner&&(t.owner!==(0,ue.HW)()?.uid||we(t))?function(e,t=!1){const n=`${t?`/avatar/guest/${e}`:`/avatar/${e}`}/32${!0===window?.matchMedia?.("(prefers-color-scheme: dark)")?.matches||null!==document.querySelector("[data-themes*=dark]")?"/dark":""}${t?"":"?guestFallback=true"}`;return`<svg width="32" height="32" viewBox="0 0 32 32"\n\t\txmlns="http://www.w3.org/2000/svg" class="sharing-status__avatar">\n\t\t<image href="${(0,ae.Jv)(n,{userId:e})}" height="32" width="32" />\n\t</svg>`}(t.owner,we(t)):Y},enabled({nodes:e}){if(1!==e.length)return!1;if((0,l.f)())return!1;const t=e[0],n=t.attributes?.["share-types"];return!!(Array.isArray(n)&&n.length>0)||!(t.owner===(0,ue.HW)()?.uid&&!we(t))||0!==(t.permissions&i.aX.SHARE)&&0!==(t.permissions&i.aX.READ)},async exec({nodes:e}){const t=e[0];return 0!==(t.permissions&i.aX.READ)?((0,i.dC)().open(t,"sharing"),null):((0,he.Qg)((0,a.Tl)("files_sharing","You do not have enough permissions to share this file.")),null)},inline:()=>!0});(0,i.Gg)(ge),(()=>{const e=(0,i.bh)();e.register(new i.Ss({id:J,name:(0,a.t)("files_sharing","Shares"),caption:(0,a.t)("files_sharing","Overview of shared files."),emptyTitle:(0,a.t)("files_sharing","No shares"),emptyCaption:(0,a.t)("files_sharing","Files and folders you shared or have been shared with you will show up here"),icon:Y,order:20,columns:[],getContents:()=>(0,W.h)()})),e.register(new i.Ss({id:Q,name:(0,a.t)("files_sharing","Shared with you"),caption:(0,a.t)("files_sharing","List of files that are shared with you."),emptyTitle:(0,a.t)("files_sharing","Nothing shared with you yet"),emptyCaption:(0,a.t)("files_sharing","Files and folders others shared with you will show up here"),icon:'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-account-outline" viewBox="0 0 24 24"><path d="M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,6A2,2 0 0,0 10,8A2,2 0 0,0 12,10A2,2 0 0,0 14,8A2,2 0 0,0 12,6M12,13C14.67,13 20,14.33 20,17V20H4V17C4,14.33 9.33,13 12,13M12,14.9C9.03,14.9 5.9,16.36 5.9,17V18.1H18.1V17C18.1,16.36 14.97,14.9 12,14.9Z" /></svg>',order:1,parent:J,columns:[],getContents:()=>(0,W.h)(!0,!1,!1,!1)})),0!==(0,K.C)("files","storageStats",{quota:-1}).quota&&e.register(new i.Ss({id:ee,name:(0,a.t)("files_sharing","Shared with others"),caption:(0,a.t)("files_sharing","List of files that you shared with others."),emptyTitle:(0,a.t)("files_sharing","Nothing shared yet"),emptyCaption:(0,a.t)("files_sharing","Files and folders you shared will show up here"),icon:q,order:2,parent:J,columns:[],getContents:()=>(0,W.h)(!1,!0,!1,!1)})),e.register(new i.Ss({id:te,name:(0,a.t)("files_sharing","Shared by link"),caption:(0,a.t)("files_sharing","List of files that are shared by link."),emptyTitle:(0,a.t)("files_sharing","No shared links"),emptyCaption:(0,a.t)("files_sharing","Files and folders you shared by link will show up here"),icon:Z,order:3,parent:J,columns:[],getContents:()=>(0,W.h)(!1,!0,!1,!1,[o.I.Link])})),e.register(new i.Ss({id:"filerequest",name:(0,a.t)("files_sharing","File requests"),caption:(0,a.t)("files_sharing","List of file requests."),emptyTitle:(0,a.t)("files_sharing","No file requests"),emptyCaption:(0,a.t)("files_sharing","File requests you have created will show up here"),icon:j,order:4,parent:J,columns:[],getContents:()=>(0,W.h)(!1,!0,!1,!1,[o.I.Link,o.I.Email]).then(({folder:e,contents:t})=>({folder:e,contents:t.filter(e=>(0,W.C)(e.attributes?.["share-attributes"]||[]))}))})),e.register(new i.Ss({id:ne,name:(0,a.t)("files_sharing","Deleted shares"),caption:(0,a.t)("files_sharing","List of shares you left."),emptyTitle:(0,a.t)("files_sharing","No deleted shares"),emptyCaption:(0,a.t)("files_sharing","Shares you have left will show up here"),icon:'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-trash-can-outline" viewBox="0 0 24 24"><path d="M9,3V4H4V6H5V19A2,2 0 0,0 7,21H17A2,2 0 0,0 19,19V6H20V4H15V3H9M7,6H17V19H7V6M9,8V17H11V8H9M13,8V17H15V8H13Z" /></svg>',order:5,parent:J,columns:[],getContents:()=>(0,W.h)(!1,!1,!1,!0)})),e.register(new i.Ss({id:ie,name:(0,a.t)("files_sharing","Pending shares"),caption:(0,a.t)("files_sharing","List of unapproved shares."),emptyTitle:(0,a.t)("files_sharing","No pending shares"),emptyCaption:(0,a.t)("files_sharing","Shares you have received but not approved will show up here"),icon:'<svg xmlns="http://www.w3.org/2000/svg" id="mdi-account-clock-outline" viewBox="0 0 24 24"><path d="M16,14H17.5V16.82L19.94,18.23L19.19,19.53L16,17.69V14M17,12A5,5 0 0,0 12,17A5,5 0 0,0 17,22A5,5 0 0,0 22,17A5,5 0 0,0 17,12M17,10A7,7 0 0,1 24,17A7,7 0 0,1 17,24C14.21,24 11.8,22.36 10.67,20H1V17C1,14.34 6.33,13 9,13C9.6,13 10.34,13.07 11.12,13.2C12.36,11.28 14.53,10 17,10M10,17C10,16.3 10.1,15.62 10.29,15C9.87,14.93 9.43,14.9 9,14.9C6.03,14.9 2.9,16.36 2.9,17V18.1H10.09C10.03,17.74 10,17.37 10,17M9,4A4,4 0 0,1 13,8A4,4 0 0,1 9,12A4,4 0 0,1 5,8A4,4 0 0,1 9,4M9,5.9A2.1,2.1 0 0,0 6.9,8A2.1,2.1 0 0,0 9,10.1A2.1,2.1 0 0,0 11.1,8A2.1,2.1 0 0,0 9,5.9Z" /></svg>',order:6,parent:J,columns:[],getContents:()=>(0,W.h)(!1,!1,!0,!1)}))})(),(0,i.zj)(z),(0,r.Yc)("nc:note",{nc:"http://nextcloud.org/ns"}),(0,r.Yc)("nc:sharees",{nc:"http://nextcloud.org/ns"}),(0,r.Yc)("nc:hide-download",{nc:"http://nextcloud.org/ns"}),(0,r.Yc)("nc:share-attributes",{nc:"http://nextcloud.org/ns"}),(0,r.Yc)("oc:share-types",{oc:"http://owncloud.org/ns"}),(0,r.Yc)("ocs:share-permissions",{ocs:"http://open-collaboration-services.org/ns"}),function(){if((0,l.f)())return;const e=(0,c.A)(d.Ay,x);Object.defineProperty(e.prototype,"attachShadow",{value(){return this}}),Object.defineProperty(e.prototype,"shadowRoot",{get(){return this}}),customElements.define(V,e),(0,i.cZ)(new U)}(),function(){let e,t;(0,i.Up)(new i.Y9({id:"note-to-recipient",order:0,enabled:e=>Boolean(e.attributes.note),updated:e=>{t&&t.updateFolder(e)},render:async(i,r)=>{if(void 0===e){const{default:t}=await Promise.all([n.e(4208),n.e(1404)]).then(n.bind(n,41404));e=d.Ay.extend(t)}t=(new e).$mount(i),t.updateFolder(r)}}))}()},87543(e,t,n){"use strict";n.d(t,{C:()=>h,h:()=>p});var i=n(21777),r=n(19051),s=n(35810),a=n(77815),o=n(63814),l=n(48564);const c={"Content-Type":"application/json"};async function d(e){try{if(void 0!==e?.remote_id){if(!e.mimetype){const t=(await n.e(857).then(n.bind(n,10857))).default;e.mimetype=t.getType(e.name)}const t="dir"===e.type?"folder":e.type;e.item_type=t||(e.mimetype?"file":"folder"),e.item_mtime=e.mtime,e.file_target=e.file_target||e.mountpoint,e.file_target.includes("TemporaryMountPointName")&&(e.file_target=e.name),e.accepted||(e.item_permissions=s.aX.NONE,e.permissions=s.aX.NONE),e.uid_owner=e.owner,e.displayname_owner=e.owner}const t="folder"===e?.item_type,i=!0===e?.has_preview,r=t?s.vd:s.ZH,o=e.file_source||e.file_id||e.id,l=e.path||e.file_target||e.name,c=`${(0,a.EY)()}${(0,a.ei)()}/${l.replace(/^\/+/,"")}`;let d,u=e.item_mtime?new Date(1e3*e.item_mtime):void 0;return e?.stime>(e?.item_mtime||0)&&(u=new Date(1e3*e.stime)),"share_with"in e&&(d={sharee:{id:e.share_with,"display-name":e.share_with_displayname||e.share_with,type:e.share_type}}),new r({id:o,source:c,owner:e?.uid_owner,mime:e?.mimetype||"application/octet-stream",mtime:u,size:e?.item_size,permissions:e?.item_permissions||e?.permissions,root:(0,a.ei)(),attributes:{...e,"has-preview":i,"hide-download":1===e?.hide_download,"owner-id":e?.uid_owner,"owner-display-name":e?.displayname_owner,"share-types":e?.share_type,"share-attributes":e?.attributes||"[]",sharees:d,favorite:e?.tags?.includes(window.OC.TAG_FAVORITE)?1:0}})}catch(e){return l.A.error("Error while parsing OCS entry",{error:e}),null}}function u(e=!1){const t=(0,o.KT)("apps/files_sharing/api/v1/shares");return r.Ay.get(t,{headers:c,params:{shared_with_me:e,include_tags:!0}})}function h(e="[]"){const t=e=>"fileRequest"===e.scope&&"enabled"===e.key&&!0===e.value;try{return JSON.parse(e).some(t)}catch(e){return l.A.error("Error while parsing share attributes",{error:e}),!1}}async function p(e=!0,t=!0,n=!1,l=!1,h=[]){const p=[];e&&p.push(u(!0),function(){const e=(0,o.KT)("apps/files_sharing/api/v1/remote_shares");return r.Ay.get(e,{headers:c,params:{include_tags:!0}})}()),t&&p.push(u()),n&&p.push(function(){const e=(0,o.KT)("apps/files_sharing/api/v1/shares/pending");return r.Ay.get(e,{headers:c,params:{include_tags:!0}})}(),function(){const e=(0,o.KT)("apps/files_sharing/api/v1/remote_shares/pending");return r.Ay.get(e,{headers:c,params:{include_tags:!0}})}()),l&&p.push(function(){const e=(0,o.KT)("apps/files_sharing/api/v1/deletedshares");return r.Ay.get(e,{headers:c,params:{include_tags:!0}})}());const f=(await Promise.all(p)).map(e=>e.data.ocs.data).flat();let w=(await Promise.all(f.map(d))).filter(e=>null!==e);var g,m;return h.length>0&&(w=w.filter(e=>h.includes(e.attributes?.share_type))),w=(g=w,m="source",Object.values(g.reduce(function(e,t){return(e[t[m]]=e[t[m]]||[]).push(t),e},{}))).map(e=>{const t=e[0];return t.attributes["share-types"]=e.map(e=>e.attributes["share-types"]),t}),{folder:new s.vd({id:0,source:`${(0,a.EY)()}${(0,a.ei)()}`,owner:(0,i.HW)()?.uid||null,root:(0,a.ei)()}),contents:w}}},87771(e,t,n){"use strict";n.d(t,{A:()=>s});var i=n(87485),r=n(81222);class s{constructor(){var e,t,n;e=this,n=void 0,(t=function(e){var t=function(e){if("object"!=typeof e||!e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var n=t.call(e,"string");if("object"!=typeof n)return n;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:t+""}(t="_capabilities"))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,this._capabilities=(0,i.F)()}get defaultPermissions(){return this._capabilities.files_sharing?.default_permissions}get isPublicUploadEnabled(){return!0===this._capabilities.files_sharing?.public?.upload}get federatedShareDocLink(){return window.OC.appConfig.core.federatedCloudShareDoc}get defaultExpirationDate(){return this.isDefaultExpireDateEnabled&&null!==this.defaultExpireDate?new Date((new Date).setDate((new Date).getDate()+this.defaultExpireDate)):null}get defaultInternalExpirationDate(){return this.isDefaultInternalExpireDateEnabled&&null!==this.defaultInternalExpireDate?new Date((new Date).setDate((new Date).getDate()+this.defaultInternalExpireDate)):null}get defaultRemoteExpirationDateString(){return this.isDefaultRemoteExpireDateEnabled&&null!==this.defaultRemoteExpireDate?new Date((new Date).setDate((new Date).getDate()+this.defaultRemoteExpireDate)):null}get enforcePasswordForPublicLink(){return!0===window.OC.appConfig.core.enforcePasswordForPublicLink}get enableLinkPasswordByDefault(){return!0===window.OC.appConfig.core.enableLinkPasswordByDefault}get isDefaultExpireDateEnforced(){return!0===window.OC.appConfig.core.defaultExpireDateEnforced}get isDefaultExpireDateEnabled(){return!0===window.OC.appConfig.core.defaultExpireDateEnabled}get isDefaultInternalExpireDateEnforced(){return!0===window.OC.appConfig.core.defaultInternalExpireDateEnforced}get isDefaultInternalExpireDateEnabled(){return!0===window.OC.appConfig.core.defaultInternalExpireDateEnabled}get isDefaultRemoteExpireDateEnforced(){return!0===window.OC.appConfig.core.defaultRemoteExpireDateEnforced}get isDefaultRemoteExpireDateEnabled(){return!0===window.OC.appConfig.core.defaultRemoteExpireDateEnabled}get isRemoteShareAllowed(){return!0===window.OC.appConfig.core.remoteShareAllowed}get isFederationEnabled(){return!0===this._capabilities?.files_sharing?.federation?.outgoing}get isPublicShareAllowed(){return!0===this._capabilities?.files_sharing?.public?.enabled}get isMailShareAllowed(){return!0===this._capabilities?.files_sharing?.sharebymail?.enabled&&!0===this.isPublicShareAllowed}get defaultExpireDate(){return window.OC.appConfig.core.defaultExpireDate}get defaultInternalExpireDate(){return window.OC.appConfig.core.defaultInternalExpireDate}get defaultRemoteExpireDate(){return window.OC.appConfig.core.defaultRemoteExpireDate}get isResharingAllowed(){return!0===window.OC.appConfig.core.resharingAllowed}get isPasswordForMailSharesRequired(){return!0===this._capabilities.files_sharing?.sharebymail?.password?.enforced}get shouldAlwaysShowUnique(){return!0===this._capabilities.files_sharing?.sharee?.always_show_unique}get allowGroupSharing(){return!0===window.OC.appConfig.core.allowGroupSharing}get maxAutocompleteResults(){return parseInt(window.OC.config["sharing.maxAutocompleteResults"],10)||25}get minSearchStringLength(){return parseInt(window.OC.config["sharing.minSearchStringLength"],10)||0}get passwordPolicy(){return this._capabilities?.password_policy||{}}get allowCustomTokens(){return this._capabilities?.files_sharing?.public?.custom_tokens}get showFederatedSharesAsInternal(){return(0,r.C)("files_sharing","showFederatedSharesAsInternal",!1)}get showFederatedSharesToTrustedServersAsInternal(){return(0,r.C)("files_sharing","showFederatedSharesToTrustedServersAsInternal",!1)}get showExternalSharing(){return(0,r.C)("files_sharing","showExternalSharing",!0)}}}},r={};function s(e){var t=r[e];if(void 0!==t)return t.exports;var n=r[e]={id:e,loaded:!1,exports:{}};return i[e].call(n.exports,n,n.exports,s),n.loaded=!0,n.exports}s.m=i,e=[],s.O=(t,n,i,r)=>{if(!n){var a=1/0;for(d=0;d<e.length;d++){for(var[n,i,r]=e[d],o=!0,l=0;l<n.length;l++)(!1&r||a>=r)&&Object.keys(s.O).every(e=>s.O[e](n[l]))?n.splice(l--,1):(o=!1,r<a&&(a=r));if(o){e.splice(d--,1);var c=i();void 0!==c&&(t=c)}}return t}r=r||0;for(var d=e.length;d>0&&e[d-1][2]>r;d--)e[d]=e[d-1];e[d]=[n,i,r]},s.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return s.d(t,{a:t}),t},s.d=(e,t)=>{for(var n in t)s.o(t,n)&&!s.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},s.f={},s.e=e=>Promise.all(Object.keys(s.f).reduce((t,n)=>(s.f[n](e,t),t),[])),s.u=e=>e+"-"+e+".js?v="+{857:"3d28157955f39376ab2c",1404:"e021afe5d02634220086",1598:"9eeea35eb186b274c0ab",2710:"0c2e26891ac1c05900e0",4471:"9b3c8620f038b7593241",7004:"da5a822695a273d4d2eb",7394:"5b773f16893ed80e0246",7859:"cd6f48c919ca307639eb",8127:"b62d5791b2d7256af4a8",8453:"0ad2c9a35eee895d5980"}[e],s.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),t={},n="nextcloud-ui-legacy:",s.l=(e,i,r,a)=>{if(t[e])t[e].push(i);else{var o,l;if(void 0!==r)for(var c=document.getElementsByTagName("script"),d=0;d<c.length;d++){var u=c[d];if(u.getAttribute("src")==e||u.getAttribute("data-webpack")==n+r){o=u;break}}o||(l=!0,(o=document.createElement("script")).charset="utf-8",s.nc&&o.setAttribute("nonce",s.nc),o.setAttribute("data-webpack",n+r),o.src=e),t[e]=[i];var h=(n,i)=>{o.onerror=o.onload=null,clearTimeout(p);var r=t[e];if(delete t[e],o.parentNode&&o.parentNode.removeChild(o),r&&r.forEach(e=>e(i)),n)return n(i)},p=setTimeout(h.bind(null,void 0,{type:"timeout",target:o}),12e4);o.onerror=h.bind(null,o.onerror),o.onload=h.bind(null,o.onload),l&&document.head.appendChild(o)}},s.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},s.nmd=e=>(e.paths=[],e.children||(e.children=[]),e),s.j=5928,(()=>{var e;globalThis.importScripts&&(e=globalThis.location+"");var t=globalThis.document;if(!e&&t&&(t.currentScript&&"SCRIPT"===t.currentScript.tagName.toUpperCase()&&(e=t.currentScript.src),!e)){var n=t.getElementsByTagName("script");if(n.length)for(var i=n.length-1;i>-1&&(!e||!/^http(s?):/.test(e));)e=n[i--].src}if(!e)throw new Error("Automatic publicPath is not supported in this browser");e=e.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=e})(),(()=>{s.b="undefined"!=typeof document&&document.baseURI||self.location.href;var e={5928:0};s.f.j=(t,n)=>{var i=s.o(e,t)?e[t]:void 0;if(0!==i)if(i)n.push(i[2]);else{var r=new Promise((n,r)=>i=e[t]=[n,r]);n.push(i[2]=r);var a=s.p+s.u(t),o=new Error;s.l(a,n=>{if(s.o(e,t)&&(0!==(i=e[t])&&(e[t]=void 0),i)){var r=n&&("load"===n.type?"missing":n.type),a=n&&n.target&&n.target.src;o.message="Loading chunk "+t+" failed.\n("+r+": "+a+")",o.name="ChunkLoadError",o.type=r,o.request=a,i[1](o)}},"chunk-"+t,t)}},s.O.j=t=>0===e[t];var t=(t,n)=>{var i,r,[a,o,l]=n,c=0;if(a.some(t=>0!==e[t])){for(i in o)s.o(o,i)&&(s.m[i]=o[i]);if(l)var d=l(s)}for(t&&t(n);c<a.length;c++)r=a[c],s.o(e,r)&&e[r]&&e[r][0](),e[r]=0;return s.O(d)},n=globalThis.webpackChunknextcloud_ui_legacy=globalThis.webpackChunknextcloud_ui_legacy||[];n.forEach(t.bind(null,0)),n.push=t.bind(null,n.push.bind(n))})(),s.nc=void 0;var a=s.O(void 0,[4208],()=>s(81382));a=s.O(a)})();
//# sourceMappingURL=files_sharing-init.js.map?v=956d8245a09e753e5c1a