(()=>{"use strict";var t,e,n,s={30514:(t,e,n)=>{n.d(e,{A:()=>i});var s=n(71354),a=n.n(s),o=n(76314),r=n.n(o)()(a());r.push([t.id,"\n#passwordform {\n\tdisplay: flex;\n\tflex-direction: column;\n\tgap: 1rem;\n\tmax-width: 400px;\n}\n","",{version:3,sources:["webpack://./apps/settings/src/components/PasswordSection.vue"],names:[],mappings:";AAmFA;CACA,aAAA;CACA,sBAAA;CACA,SAAA;CACA,gBAAA;AACA",sourcesContent:['\x3c!--\n  - SPDX-FileCopyrightText: 2022 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n<template>\n\t<NcSettingsSection :name="t(\'settings\', \'Password\')">\n\t\t<form id="passwordform" method="POST" @submit.prevent="changePassword">\n\t\t\t<NcPasswordField id="old-pass"\n\t\t\t\t:label="t(\'settings\', \'Current password\')"\n\t\t\t\tname="oldpassword"\n\t\t\t\t:value.sync="oldPass"\n\t\t\t\tautocomplete="current-password"\n\t\t\t\tautocapitalize="none"\n\t\t\t\tspellcheck="false" />\n\n\t\t\t<NcPasswordField id="new-pass"\n\t\t\t\t:label="t(\'settings\', \'New password\')"\n\t\t\t\t:value.sync="newPass"\n\t\t\t\t:maxlength="469"\n\t\t\t\tautocomplete="new-password"\n\t\t\t\tautocapitalize="none"\n\t\t\t\tspellcheck="false"\n\t\t\t\t:check-password-strength="true" />\n\n\t\t\t<NcButton type="primary"\n\t\t\t\tnative-type="submit"\n\t\t\t\t:disabled="newPass.length === 0 || oldPass.length === 0">\n\t\t\t\t{{ t(\'settings\', \'Change password\') }}\n\t\t\t</NcButton>\n\t\t</form>\n\t</NcSettingsSection>\n</template>\n\n<script>\nimport NcSettingsSection from \'@nextcloud/vue/dist/Components/NcSettingsSection.js\'\nimport NcButton from \'@nextcloud/vue/dist/Components/NcButton.js\'\nimport NcPasswordField from \'@nextcloud/vue/dist/Components/NcPasswordField.js\'\nimport axios from \'@nextcloud/axios\'\nimport { generateUrl } from \'@nextcloud/router\'\nimport { showSuccess, showError } from \'@nextcloud/dialogs\'\n\nexport default {\n\tname: \'PasswordSection\',\n\tcomponents: {\n\t\tNcSettingsSection,\n\t\tNcButton,\n\t\tNcPasswordField,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\toldPass: \'\',\n\t\t\tnewPass: \'\',\n\t\t}\n\t},\n\tmethods: {\n\t\tchangePassword() {\n\t\t\taxios.post(generateUrl(\'/settings/personal/changepassword\'), {\n\t\t\t\toldpassword: this.oldPass,\n\t\t\t\tnewpassword: this.newPass,\n\t\t\t})\n\t\t\t\t.then(res => res.data)\n\t\t\t\t.then(data => {\n\t\t\t\t\tif (data.status === \'error\') {\n\t\t\t\t\t\tthis.errorMessage = data.data.message\n\t\t\t\t\t\tshowError(data.data.message)\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowSuccess(data.data.message)\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n\t#passwordform {\n\t\tdisplay: flex;\n\t\tflex-direction: column;\n\t\tgap: 1rem;\n\t\tmax-width: 400px;\n\t}\n</style>\n'],sourceRoot:""}]);const i=r},85526:(t,e,n)=>{var s=n(85471),a=n(88837),o=n(21376),r=n(16044),i=n(19051),l=n(63814),d=n(85168);const c={name:"PasswordSection",components:{NcSettingsSection:a.A,NcButton:o.A,NcPasswordField:r.A},data:()=>({oldPass:"",newPass:""}),methods:{changePassword(){i.Ay.post((0,l.Jv)("/settings/personal/changepassword"),{oldpassword:this.oldPass,newpassword:this.newPass}).then((t=>t.data)).then((t=>{"error"===t.status?(this.errorMessage=t.data.message,(0,d.Qg)(t.data.message)):(0,d.Te)(t.data.message)}))}}};var p=n(85072),u=n.n(p),m=n(97825),f=n.n(m),w=n(77659),g=n.n(w),h=n(55056),v=n.n(h),b=n(10540),P=n.n(b),A=n(41113),y=n.n(A),S=n(30514),x={};x.styleTagTransform=y(),x.setAttributes=v(),x.insert=g().bind(null,"head"),x.domAPI=f(),x.insertStyleElement=P(),u()(S.A,x),S.A&&S.A.locals&&S.A.locals;const N=(0,n(14486).A)(c,(function(){var t=this,e=t._self._c;return e("NcSettingsSection",{attrs:{name:t.t("settings","Password")}},[e("form",{attrs:{id:"passwordform",method:"POST"},on:{submit:function(e){return e.preventDefault(),t.changePassword.apply(null,arguments)}}},[e("NcPasswordField",{attrs:{id:"old-pass",label:t.t("settings","Current password"),name:"oldpassword",value:t.oldPass,autocomplete:"current-password",autocapitalize:"none",spellcheck:"false"},on:{"update:value":function(e){t.oldPass=e}}}),t._v(" "),e("NcPasswordField",{attrs:{id:"new-pass",label:t.t("settings","New password"),value:t.newPass,maxlength:469,autocomplete:"new-password",autocapitalize:"none",spellcheck:"false","check-password-strength":!0},on:{"update:value":function(e){t.newPass=e}}}),t._v(" "),e("NcButton",{attrs:{type:"primary","native-type":"submit",disabled:0===t.newPass.length||0===t.oldPass.length}},[t._v("\n\t\t\t"+t._s(t.t("settings","Change password"))+"\n\t\t")])],1)])}),[],!1,null,null,null).exports;var C=n(53334);n.nc=btoa(OC.requestToken),s.Ay.prototype.t=C.Tl,s.Ay.prototype.n=C.zw,new s.Ay({el:"#security-password",name:"main-personal-password",render:t=>t(N)})}},a={};function o(t){var e=a[t];if(void 0!==e)return e.exports;var n=a[t]={id:t,loaded:!1,exports:{}};return s[t].call(n.exports,n,n.exports,o),n.loaded=!0,n.exports}o.m=s,t=[],o.O=(e,n,s,a)=>{if(!n){var r=1/0;for(c=0;c<t.length;c++){for(var[n,s,a]=t[c],i=!0,l=0;l<n.length;l++)(!1&a||r>=a)&&Object.keys(o.O).every((t=>o.O[t](n[l])))?n.splice(l--,1):(i=!1,a<r&&(r=a));if(i){t.splice(c--,1);var d=s();void 0!==d&&(e=d)}}return e}a=a||0;for(var c=t.length;c>0&&t[c-1][2]>a;c--)t[c]=t[c-1];t[c]=[n,s,a]},o.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return o.d(e,{a:e}),e},o.d=(t,e)=>{for(var n in e)o.o(e,n)&&!o.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},o.f={},o.e=t=>Promise.all(Object.keys(o.f).reduce(((e,n)=>(o.f[n](t,e),e)),[])),o.u=t=>t+"-"+t+".js?v="+{640:"d8bb2b1f4eeab8f50472",4057:"a53adba637d509768ab9",5771:"d141d1ad8187d99738b9",7471:"6423b9b898ffefeb7d1d"}[t],o.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),o.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),e={},n="nextcloud:",o.l=(t,s,a,r)=>{if(e[t])e[t].push(s);else{var i,l;if(void 0!==a)for(var d=document.getElementsByTagName("script"),c=0;c<d.length;c++){var p=d[c];if(p.getAttribute("src")==t||p.getAttribute("data-webpack")==n+a){i=p;break}}i||(l=!0,(i=document.createElement("script")).charset="utf-8",o.nc&&i.setAttribute("nonce",o.nc),i.setAttribute("data-webpack",n+a),i.src=t),e[t]=[s];var u=(n,s)=>{i.onerror=i.onload=null,clearTimeout(m);var a=e[t];if(delete e[t],i.parentNode&&i.parentNode.removeChild(i),a&&a.forEach((t=>t(s))),n)return n(s)},m=setTimeout(u.bind(null,void 0,{type:"timeout",target:i}),12e4);i.onerror=u.bind(null,i.onerror),i.onload=u.bind(null,i.onload),l&&document.head.appendChild(i)}},o.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},o.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),o.j=186,(()=>{var t;o.g.importScripts&&(t=o.g.location+"");var e=o.g.document;if(!t&&e&&(e.currentScript&&"SCRIPT"===e.currentScript.tagName.toUpperCase()&&(t=e.currentScript.src),!t)){var n=e.getElementsByTagName("script");if(n.length)for(var s=n.length-1;s>-1&&(!t||!/^http(s?):/.test(t));)t=n[s--].src}if(!t)throw new Error("Automatic publicPath is not supported in this browser");t=t.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),o.p=t})(),(()=>{o.b="undefined"!=typeof document&&document.baseURI||self.location.href;var t={186:0};o.f.j=(e,n)=>{var s=o.o(t,e)?t[e]:void 0;if(0!==s)if(s)n.push(s[2]);else{var a=new Promise(((n,a)=>s=t[e]=[n,a]));n.push(s[2]=a);var r=o.p+o.u(e),i=new Error;o.l(r,(n=>{if(o.o(t,e)&&(0!==(s=t[e])&&(t[e]=void 0),s)){var a=n&&("load"===n.type?"missing":n.type),r=n&&n.target&&n.target.src;i.message="Loading chunk "+e+" failed.\n("+a+": "+r+")",i.name="ChunkLoadError",i.type=a,i.request=r,s[1](i)}}),"chunk-"+e,e)}},o.O.j=e=>0===t[e];var e=(e,n)=>{var s,a,[r,i,l]=n,d=0;if(r.some((e=>0!==t[e]))){for(s in i)o.o(i,s)&&(o.m[s]=i[s]);if(l)var c=l(o)}for(e&&e(n);d<r.length;d++)a=r[d],o.o(t,a)&&t[a]&&t[a][0](),t[a]=0;return o.O(c)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),o.nc=void 0;var r=o.O(void 0,[4208],(()=>o(85526)));r=o.O(r)})();
//# sourceMappingURL=settings-vue-settings-personal-password.js.map?v=8fa27acd625285521964